package com.bxm.localnews.news.manage;

import com.bxm.localnews.news.model.param.AdminTopicParam;
import com.bxm.localnews.news.model.param.AdminTopicUpdateParam;
import com.bxm.localnews.news.model.param.manage.TopicUpdateParam;
import com.bxm.localnews.news.model.param.manage.UpdateOrderParam;
import com.bxm.localnews.news.model.vo.topic.AdminTopic;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.topic.AdminTopicService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

@Api(tags = "9-03 [管理]话题管理", description = "话题管理")
@RestController
@RequestMapping("manage/news/topic")
public class AdminTopicController extends BaseController {

    @Resource
    private AdminTopicService adminTopicService;

    @Resource
    private ForumPostService forumPostService;

    @ApiOperation(value = "9-03-1 获取话题列表")
    @GetMapping("list")
    public ResponseJson<IPageModel<AdminTopic>> getList(AdminTopicParam param) {
        return ResponseJson.ok(adminTopicService.getList(param));
    }

    @ApiOperation(value = "9-03-2 获取话题详情")
    @GetMapping("detail")
    public ResponseJson<AdminTopic> getTopicById(Long id) {
        return ResponseJson.ok(adminTopicService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "9-03-3 话题上下架删除")
    @PostMapping("updateStatus")
    public ResponseJson<Integer> updateStatusById(@Valid @RequestBody TopicUpdateParam param) {
        return ResponseJson.ok(adminTopicService.updateStatus(param.getId(), param.getStatus()));
    }

    @ApiOperation(value = "9-03-4 新增或编辑话题")
    @PostMapping("saveOrUpdate")
    public ResponseJson<Integer> saveOrUpdate(@RequestBody AdminTopic adminTopic) {
        return ResponseJson.ok(adminTopicService.saveOrUpdate(adminTopic));
    }

    @ApiOperation(value = "9-03-5 修改话题权重")
    @PostMapping("updateOrder")
    public ResponseJson<Integer> updateOrderById(@Valid @RequestBody UpdateOrderParam param) {
        return ResponseJson.ok(adminTopicService.updateOrder(param.getId(), param.getOrder()));
    }

    @ApiOperation(value = "9-03-6 获取简单话题列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "key", value = "关键字")
    })
    @GetMapping("getSimpleList")
    public ResponseJson<List<AdminTopic>> getSimpleList(String key) {
        return ResponseJson.ok(adminTopicService.getSimpleList(key));
    }

    @ApiOperation(value = "9-03-7 根据话题id获取话题下的帖子数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true)
    })
    @GetMapping("getPostNumByTopicId")
    public ResponseJson<Integer> getPostNumByTopicId(Long id) {
        return ResponseJson.ok(adminTopicService.getPostNumByTopicId(id));
    }

    @ApiOperation(value = "9-03-8 编辑帖子中的话题", notes = "为了扩展性，话题支持多个id")
    @PostMapping("/post/update")
    public ResponseJson updateTopicOrForum(@RequestBody AdminTopicUpdateParam adminTopicUpdateParam) {
        forumPostService.updateTopic(adminTopicUpdateParam.getId(), adminTopicUpdateParam.getTopicIdList(), null);
        return ResponseJson.ok().build();
    }

}

