/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.list.PostListService;
import com.bxm.localnews.news.model.dto.ShareContentDTO;
import com.bxm.localnews.news.model.param.FollowUserForumsParam;
import com.bxm.localnews.news.model.param.ForumPostListQueryParam;
import com.bxm.localnews.news.model.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.model.param.HomePagePostParam;
import com.bxm.localnews.news.model.vo.FollowUserForumPostVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.service.ShareRankService;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-01 \u5e16\u5b50\u7684\u5404\u79cd\u5217\u8868\u63a5\u53e3"})
@RestController
@RequestMapping(value={"{version}/news/list"})
public class ForumListController
extends BaseController {
    private PostListService postListService;
    private final ShareRankService shareRankService;

    @ApiOperation(value="9-01-1 [v1]\u83b7\u53d6\u4e0d\u540c\u573a\u666f\u4e0b\u7684\u5e16\u5b50\u5217\u8868", notes="\u573a\u666f\u5305\u62ec\uff1a0\u70ed\u95e8 1\u7cbe\u9009 2\u6700\u65b0 3\u793e\u533a\u9996\u9875")
    @GetMapping(value={"getPostPage"})
    @ApiVersion(value=1)
    public Json<PageWarper<ForumPostVo>> getPostPage(@Valid ForumPostListQueryParam param) {
        return ResultUtil.genSuccessResult((Object)this.postListService.listForumPost(param));
    }

    @ApiOperation(value="9-01-2 [v1]\u83b7\u53d6\u7528\u6237\u53d1\u5e16\u5217\u8868", notes="\u5728\u79c1\u804a\u3001\u6211\u7684\u5e16\u5b50\u3001\u6211\u7684\u6536\u85cf\u4e2d\u663e\u793a\u7528\u6237\u7684\u5bf9\u5e94\u5e16\u5b50\u4fe1\u606f")
    @GetMapping(value={"security/getPostPageByUser"})
    @ApiVersion(value=1)
    public Json<PageWarper<ForumPostVo>> getPostPageByUser(ForumPostListUserQueryParam param) {
        return ResultUtil.genSuccessResult((Object)this.postListService.listForumPostByUser(param));
    }

    @ApiOperation(value="9-01-3 [v1]\u5173\u6ce8\u7528\u6237\u5e16\u5b50\u5217\u8868", notes="\u5728\u672c\u5730\u5708-\u5173\u6ce8tab\u4e2d\u663e\u793a\u5f53\u524d\u7528\u6237\u5173\u6ce8\u7684\u7528\u6237\u53d1\u5e16\u4fe1\u606f")
    @GetMapping(value={"followUserForums"})
    @ApiVersion(value=1)
    public ResponseJson<FollowUserForumPostVo> followUserForums(@Valid FollowUserForumsParam param, BasicParam basicParam) {
        return ResponseJson.ok((Object)this.postListService.getFollowedUserForumList(param, basicParam));
    }

    @ApiOperation(value="9-01-4 [v1]\u4e2a\u4eba\u4e3b\u9875 \u5e16\u5b50\u5217\u8868", notes="\u8fdb\u5165\u4e2a\u4eba\u4e3b\u9875\u540e\u663e\u793a\u5e16\u5b50\u5217\u8868\uff0c\u5206\u4e3a\u4e3b\u6001\u548c\u5ba2\u6001")
    @GetMapping(value={"getHomePagePostList"})
    @ApiVersion(value=1)
    public Json<PageWarper<ForumPostVo>> getHomePagePostList(HomePagePostParam param, BasicParam basicParam) {
        return ResultUtil.genSuccessResult((Object)this.postListService.getHomePagePostList(param, basicParam));
    }

    @ApiOperation(value="9-01-5 [v1]\u6839\u636e\u5e16\u5b50id\u5217\u8868\u83b7\u53d6\u5e16\u5b50\u5217\u8868", notes="\u6682\u65f6\u4e0d\u77e5\u9053\u54ea\u91cc\u8c03\u7528\u5230\u4e86")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postIds", value="\u5e16\u5b50id\u5217\u8868\uff0c\u9017\u53f7\u5206\u9694", required=true)})
    @GetMapping(value={"public/getPostListByIds"})
    public Json<List<ForumPostVo>> getPostListByIds(String postIds) {
        return ResultUtil.genSuccessResult((Object)this.postListService.getPostListByIds(postIds));
    }

    @ApiOperation(value="9-01-6 [v1]\u83b7\u53d6\u67d0\u5730\u533a\u9605\u8bfb\u6392\u884c\u9760\u524d\u7684\u5185\u5bb9\uff0c\u7528\u4e8e\u5206\u4eab", notes="\u9700\u8981\u5206\u4eab\u5e16\u5b50\u7684\u5730\u65b9\uff0c\u83b7\u53d6\u5f53\u524d\u533a\u57df\u53ef\u7528\u4e8e\u5206\u4eab\u7684\u4e00\u4e9b\u5e16\u5b50")
    @GetMapping(value={"top"})
    @ApiVersion(value=1)
    public ResponseJson<List<ShareContentDTO>> getTopToShare(BaseAreaCodeParam param) {
        return ResponseJson.ok((Object)this.shareRankService.getTopPost(param.getAreaCode()));
    }

    public ForumListController(PostListService postListService, ShareRankService shareRankService) {
        this.postListService = postListService;
        this.shareRankService = shareRankService;
    }
}

