/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.localnews.news.activity.GrainTotalService;
import com.bxm.localnews.news.detail.ForumPostDetailService;
import com.bxm.localnews.news.detail.context.PostDetailOriginalParam;
import com.bxm.localnews.news.model.dto.ForumPostLikeDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-03 \u5185\u5bb9\u8be6\u60c5\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"{version}/news/detail"})
public class ForumPostDetailController {
    private ForumPostDetailService forumPostDetailService;
    private PostLikeService postLikeService;
    private GrainTotalService grainTotalService;

    @ApiOperation(value="9-03-1 [v1]\u6839\u636eid\u83b7\u53d6\u5e16\u5b50\u8be6\u60c5", notes="\u7ad9\u5185\u3001\u7ad9\u5916\u90fd\u662f\u8d70\u8fd9\u4e2a\u63a5\u53e3")
    @GetMapping(value={"getPostDetailById"})
    @ApiVersion(value=1)
    public Json<ForumPostVo> getPostDetailById(PostDetailOriginalParam param, HttpServletRequest request) {
        param.setBasicParam((BasicParam)param);
        param.setIp(WebUtils.getIpAddr((HttpServletRequest)request));
        this.grainTotalService.addVisibleNumByPostDetail(param.getId());
        return ResultUtil.genSuccessResult((Object)this.forumPostDetailService.get(param));
    }

    @ApiOperation(value="9-03-2 [v1]\u6839\u636e\u5e16\u5b50id\u83b7\u5f97\u70b9\u8d5e\u5217\u8868", notes="\u5e16\u5b50\u8be6\u60c5\u4e2d\u70b9\u51fb\u70b9\u8d5e\u4fe1\u606f\u52a0\u8f7d\u66f4\u591a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postId", value="\u5e16\u5b50id", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="devcId", value="\u8bbe\u5907id", required=false)})
    @GetMapping(value={"getPostLikeDetailById"})
    @ApiVersion(value=1)
    public Json<List<ForumPostLikeDTO>> getPostLikeDetailById(Long postId, Long userId, String devcId) {
        return ResultUtil.genSuccessResult((Object)this.postLikeService.getPostLikeDetail(postId, userId, devcId));
    }

    public ForumPostDetailController(ForumPostDetailService forumPostDetailService, PostLikeService postLikeService, GrainTotalService grainTotalService) {
        this.forumPostDetailService = forumPostDetailService;
        this.postLikeService = postLikeService;
        this.grainTotalService = grainTotalService;
    }
}

