/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.localnews.news.activity.GrainPostService;
import com.bxm.localnews.news.activity.GrainTotalService;
import com.bxm.localnews.news.model.dto.grain.GrainListDTO;
import com.bxm.localnews.news.model.dto.grain.GrainTotalListDTO;
import com.bxm.localnews.news.model.param.BasePostParam;
import com.bxm.localnews.news.model.param.GrainPromotionParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-08 \u5f00\u4ed3\u653e\u7cae\u5e16\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"{version}/news/grain"})
public class GrainPostController {
    private GrainPostService grainPostService;
    private GrainTotalService grainTotalService;

    @ApiOperation(value="9-08-1 [v1]\u83b7\u53d6\u5f00\u4ed3\u653e\u7cae\u4fe1\u606f", notes="\u5305\u542b\u5f00\u4ed3\u653e\u7cae\u7684\u8bdd\u9898ID\u548c\u5bf9\u5e94\u7684\u5217\u8868\u4fe1\u606f")
    @GetMapping(value={"list"})
    @ApiVersion(value=1)
    public ResponseJson<GrainListDTO> list(BaseAreaCodeParam param) {
        return ResponseJson.ok((Object)this.grainPostService.recommendIndex(param));
    }

    @ApiOperation(value="9-08-2 [v1]\u5b9e\u73b0\u6709\u6548\u9605\u8bfb\u540e\uff0c\u7ed9\u7528\u6237\u53d1\u7cae\u98df", notes="\u5982\u679c\u8fd4\u56de400\uff0c\u5219\u8bf4\u660e\u9886\u53d6\u5931\u8d25\uff0c\u8fd4\u56de\u7684result\u4e3a\u9519\u8bef\u4fe1\u606f")
    @PostMapping(value={"security/grant"})
    @ApiVersion(value=1)
    public ResponseJson grant(@Valid @RequestBody BasePostParam param) {
        return ResponseJson.build((Message)this.grainPostService.grant(param));
    }

    @ApiOperation(value="9-08-3 [v1]\u4fdd\u5b58\u4ed8\u8d39\u63a8\u5e7f\u4fe1\u606f", notes="\u8fd4\u56de\u4ed8\u8d39\u63a8\u5e7f\u4fe1\u606f\u7684ID\uff0c\u7136\u540e\u53d1\u8d77\u652f\u4ed8\u8bf7\u6c42\u3002\u5982\u679c\u8fd4\u56de\u4e3a\u7a7a\u6216code\u4e3a400\uff0c\u5219\u8bf4\u660e\u91cd\u590d")
    @PostMapping(value={"security/save"})
    @ApiVersion(value=1)
    public ResponseJson<Long> save(@Valid @RequestBody GrainPromotionParam param) {
        Message message = this.grainPostService.save(param);
        if (message.isSuccess()) {
            Long id = (Long)message.getParam("id");
            return ResponseJson.ok((Object)id);
        }
        return ResponseJson.badReqeuset((String)message.getLastMessage()).build();
    }

    @ApiOperation(value="9-08-4 [v1]\u83b7\u53d6\u5e16\u5b50\u63a8\u5e7f\u6570\u636e", notes="\u8fd4\u56de\u5e16\u5b50\u63a8\u5e7f\u6570\u636e\u5217\u8868")
    @GetMapping(value={"security/queryActivityGrainTotal/{postId}"})
    @ApiVersion(value=1)
    public ResponseJson<List<GrainTotalListDTO>> queryActivityGrainTotal(@PathVariable(value="postId") Long postId) {
        return ResponseJson.ok((Object)this.grainTotalService.queryActivityGrainTotal(postId));
    }

    public GrainPostController(GrainPostService grainPostService, GrainTotalService grainTotalService) {
        this.grainPostService = grainPostService;
        this.grainTotalService = grainTotalService;
    }
}

