/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.manage;

import com.bxm.component.office.excel.export.impl.SimpleExcelExporter;
import com.bxm.component.office.excel.export.setting.ExcelSheet;
import com.bxm.component.office.excel.export.setting.ExportSetting;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.localnews.news.approve.PostApproveService;
import com.bxm.localnews.news.create.PostCreateService;
import com.bxm.localnews.news.model.dto.AdminGetPostUrlDTO;
import com.bxm.localnews.news.model.param.AdminForumPostParam;
import com.bxm.localnews.news.model.param.manage.AddPostLikeParam;
import com.bxm.localnews.news.model.param.manage.DeleteOrRecoverParam;
import com.bxm.localnews.news.model.param.manage.PostApproveParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminForumPostApproveHistory;
import com.bxm.localnews.news.post.AdminForumPostService;
import com.bxm.localnews.news.util.SecurityUtils;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"9-01 [\u7ba1\u7406]\u5e16\u5b50\u7ba1\u7406"}, description="\u5e16\u5b50\u7ba1\u7406")
@RestController
@RequestMapping(value={"manage/news/forumPost"})
public class AdminForumPostController
extends BaseController {
    private AdminForumPostService adminForumPostService;
    private PostLikeService postLikeService;
    private PostApproveService postApproveService;
    private PostCreateService postCreateService;

    @ApiOperation(value="9-01-1 \u83b7\u53d6\u5e16\u5b50\u5ba1\u6838\u5217\u8868")
    @GetMapping(value={"/listApprove"})
    public ResponseJson<IPageModel<AdminForumPost>> getApprovePostList(AdminForumPostParam param) {
        return ResponseJson.ok((Object)this.adminForumPostService.getApproveList(param));
    }

    @ApiOperation(value="9-01-2 \u83b7\u53d6\u5e16\u5b50\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public ResponseJson<AdminForumPost> getForumPostById(Long id) {
        return ResponseJson.ok((Object)this.adminForumPostService.selectByPrimaryKey(id));
    }

    @ApiOperation(value="9-01-3 \u6279\u91cf\u5e16\u5b50\u5ba1\u6838")
    @PostMapping(value={"approve"})
    public ResponseJson approve(@Valid @RequestBody PostApproveParam param) {
        this.postApproveService.batchApprove(param.getIds(), param.getStatus(), param.getComment(), SecurityUtils.getAdminUserId());
        return ResponseJson.ok().build();
    }

    @ApiOperation(value="9-01-4 \u65b0\u589e\u6216\u7f16\u8f91\u5e16\u5b50")
    @PostMapping(value={"saveOrUpdate"})
    public ResponseJson saveOrUpdate(@RequestBody AdminForumPost adminForumPost) {
        return ResponseJson.build((Message)this.postCreateService.saveAdminPost(adminForumPost, SecurityUtils.getAdminUserId()));
    }

    @ApiOperation(value="9-01-5 \u6279\u91cf\u5220\u9664\u6216\u6062\u590d\u5e16\u5b50")
    @PostMapping(value={"deleteOrRecover"})
    public ResponseJson<Integer> deleteOrRecover(@RequestBody DeleteOrRecoverParam param) {
        return ResponseJson.ok((Object)this.adminForumPostService.deleteOrRecover(param.getIds(), param.getStatus(), param.getDeductGold()));
    }

    @ApiOperation(value="9-01-6 \u83b7\u53d6\u65b0\u589e\u5e16\u5b50id")
    @ApiImplicitParam(name="postType", value="\u5e16\u5b50\u7c7b\u578b,3:\u6d3b\u52a8\u5e16\u5b50\uff0c\u5176\u4ed6\uff1a\u793e\u533a\u5e16\u5b50")
    @GetMapping(value={"/getCreateId"})
    public ResponseJson<Long> getCreateId(@RequestParam(value="postType", required=false) Integer postType) {
        return ResponseJson.ok((Object)this.adminForumPostService.getCreateId(postType));
    }

    @ApiOperation(value="9-01-7 \u83b7\u53d6\u5e16\u5b50\u5ba1\u6838\u5386\u53f2\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e16\u5b50id", required=true), @ApiImplicitParam(name="action", value="\u5ba1\u6279\u52a8\u4f5c\uff1a0\u62d2\u7edd\uff0c1\u901a\u8fc7")})
    @GetMapping(value={"/listApproveHistory"})
    public ResponseJson<List<AdminForumPostApproveHistory>> getApproveHistoryList(Long id, Integer action) {
        return ResponseJson.ok((Object)this.postApproveService.getApproveHistoryList(id, action));
    }

    @ApiOperation(value="9-01-9 \u589e\u52a0\u5e16\u5b50\u9a6c\u7532\u53f7\u70b9\u8d5e", notes="\u5e16\u5b50\u9a6c\u7532\u53f7\u70b9\u8d5e")
    @PostMapping(value={"/addPostLike"})
    public ResponseJson addPostLike(@Valid @RequestBody AddPostLikeParam param) {
        this.postLikeService.doAddPostLike(param);
        return ResponseJson.ok().build();
    }

    @ApiOperation(value="9-01-10 \u5224\u65ad\u5e16\u5b50\u5217\u8868\u4e2d\u662f\u5426\u5b58\u5728\u73b0\u91d1\u5956\u52b1\u8d34")
    @ApiImplicitParam(name="ids", value="\u5e16\u5b50ID\u5217\u8868")
    @GetMapping(value={"hasCashPost"})
    public ResponseJson<Boolean> hasCashPost(String ids) {
        return ResponseJson.ok((Object)this.adminForumPostService.hasCashPost(ids));
    }

    @ApiOperation(value="9-01-12 \u83b7\u53d6\u94fe\u63a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="areaCode", value="\u533a\u57df\u7f16\u7801", required=true), @ApiImplicitParam(name="id", value="\u5e16\u5b50id", required=true), @ApiImplicitParam(name="cityName", value="\u533a\u57df\u540d\u79f0", required=true), @ApiImplicitParam(name="type", value="0-\u77ed\u94fe 1-\u957f\u94fe\u63a5 2-\u7ad9\u5185\u94fe\u63a5", required=true), @ApiImplicitParam(name="channel", value="\u9884\u7559\u5b57\u6bb5-\u6e20\u9053\u540d\u79f0\uff0c\u73b0\u5728\u9ed8\u8ba4\u662fwx")})
    @GetMapping(value={"getPostUrl"})
    public ResponseJson<String> getPostUrl(@ApiIgnore AdminGetPostUrlDTO adminGetPostUrlDTO) {
        return ResponseJson.ok((Object)this.adminForumPostService.getPostUrl(adminGetPostUrlDTO));
    }

    @ApiOperation(value="9-01-13 \u83b7\u53d6\u5e16\u5b50\u5217\u8868\u6587\u4ef6\uff08\u6b64\u65b9\u6cd5\u5c06\u8fd4\u56de\u6587\u4ef6\u6d41\uff09")
    @GetMapping(value={"listApprove/excel"})
    public ResponseJson getApprovePostListExcel(AdminForumPostParam param, HttpServletResponse response) throws IOException {
        Date maxBefore = DateUtils.addField((Date)new Date(), (int)5, (int)-30);
        if (Objects.isNull(param.getPublishStartTime())) {
            param.setPublishStartTime(maxBefore);
        } else if (param.getPublishStartTime().before(maxBefore)) {
            return ResponseJson.badReqeuset((String)"\u4e0d\u5141\u8bb8\u4e0b\u8f7d30\u5929\u4e4b\u524d\u7684\u5e16\u5b50").build();
        }
        param.setPageNum(null);
        param.setPageSize(null);
        List approveList = this.adminForumPostService.getApproveListExcelVO(param);
        SimpleExcelExporter excelExporter = (SimpleExcelExporter)SpringContextHolder.getBean(SimpleExcelExporter.class);
        ExportSetting setting = new ExportSetting();
        ExcelSheet excelSheet = setting.addSheet();
        excelSheet.setDataCollection((Collection)approveList);
        excelSheet.setFreezeHeader(true);
        excelSheet.setSheetName("\u5e16\u5b50\u5217\u8868");
        excelSheet.setDefaultWidth(30);
        excelSheet.addHeader(new SheetHeader("\u5e16\u5b50id", "id"));
        excelSheet.addHeader(new SheetHeader("\u5e16\u5b50\u6807\u9898", "title"));
        excelSheet.addHeader(new SheetHeader("\u53d1\u5e16\u5730\u5740", "location"));
        excelSheet.addHeader(new SheetHeader("\u53d1\u5e16\u533a\u57df\u7f16\u7801", "areaCode"));
        excelSheet.addHeader(new SheetHeader("\u5e16\u5b50\u6587\u672c", "textField"));
        excelSheet.addHeader(new SheetHeader("\u4f5c\u8005id", "userId"));
        excelSheet.addHeader(new SheetHeader("\u4f5c\u8005\u540d\u79f0", "userName"));
        excelSheet.addHeader(new SheetHeader("\u662f\u5426\u7cbe\u534e\u5e16", "isBrilliant"));
        excelSheet.addHeader(new SheetHeader("\u662f\u5426\u63a8\u8350\uff08\u662f\u5426\u4f18\u8d28\u5934\u6761\uff09", "isRecommend"));
        excelSheet.addHeader(new SheetHeader("\u662f\u5426\u7ea2\u8272\u7ae0", "isRed"));
        excelSheet.addHeader(new SheetHeader("\u662f\u5426\u5956\u52b1\u73b0\u91d1", "isCash"));
        excelSheet.addHeader(new SheetHeader("\u73b0\u91d1\u5956\u52b1\u91d1\u989d", "cashReward"));
        excelSheet.addHeader(new SheetHeader("\u662f\u5426\u672c\u5730\u7206\u6599", "isBroke"));
        excelSheet.addHeader(new SheetHeader("\u521b\u5efa\u65f6\u95f4", "createTime"));
        excelSheet.addHeader(new SheetHeader("\u5b9a\u65f6\u53d1\u5e03\u65f6\u95f4", "publishTime"));
        excelSheet.addHeader(new SheetHeader("\u5c55\u793a\u65f6\u95f4", "displayTime"));
        excelSheet.addHeader(new SheetHeader("\u5e16\u5b50\u72b6\u6001", "status"));
        excelSheet.addHeader(new SheetHeader("\u53d1\u5e03\u533a\u57df\u7c7b\u578b", "deliveryType"));
        excelSheet.addHeader(new SheetHeader("\u5e16\u5b50\u7c7b\u578b", "postType"));
        excelSheet.addHeader(new SheetHeader("\u6709\u6548\u671f", "validDay"));
        excelSheet.addHeader(new SheetHeader("\u5230\u671f\u65f6\u95f4", "validDate"));
        excelSheet.addHeader(new SheetHeader("\u53d1\u5e16\u533a\u57df", "areaDetail"));
        excelSheet.addHeader(new SheetHeader("\u8bdd\u9898id\u5217\u8868", "topicIdList"));
        excelSheet.addHeader(new SheetHeader("\u66f4\u65b0\u65f6\u95f4", "modifyTime"));
        excelSheet.addHeader(new SheetHeader("\u53d1\u5e16\u4eba\u8eab\u4efd", "identity"));
        excelSheet.addHeader(new SheetHeader("\u662f\u5426\u8fc7\u671f", "isValid"));
        this.processDownload(((DateFormat)DateUtils.DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL.get()).format(new Date()) + "\u5e16\u5b50\u6279\u91cf\u5bfc\u51fa.xls", response);
        excelExporter.export((OutputStream)response.getOutputStream(), setting);
        return ResponseJson.build();
    }

    @ApiOperation(value="9-01-14 \u83b7\u53d6\u5f00\u4ed3\u653e\u7cae\u7684\u5e16\u5b50\u5217\u8868")
    @GetMapping(value={"/listGrainApprove"})
    public ResponseJson<IPageModel<AdminForumPost>> getGrainPostList(AdminForumPostParam param) {
        return ResponseJson.ok((Object)this.adminForumPostService.getApproveGrainList(param));
    }

    public AdminForumPostController(AdminForumPostService adminForumPostService, PostLikeService postLikeService, PostApproveService postApproveService, PostCreateService postCreateService) {
        this.adminForumPostService = adminForumPostService;
        this.postLikeService = postLikeService;
        this.postApproveService = postApproveService;
        this.postCreateService = postCreateService;
    }
}

