/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.manage;

import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.comment.NewNewsReplyService;
import com.bxm.localnews.news.model.dto.AdminReplyDTOAdmin;
import com.bxm.localnews.news.model.dto.AdminReplyDetailDTO;
import com.bxm.localnews.news.model.param.AdminAllReplyParam;
import com.bxm.localnews.news.model.param.AdminCommentReplyParam;
import com.bxm.localnews.news.model.param.AdminNewsReplyOriginalParam;
import com.bxm.localnews.news.model.param.AdminNewsReplyParam;
import com.bxm.localnews.news.model.param.ReplyStatusChangeParam;
import com.bxm.localnews.news.model.param.manage.RemoveReplayParam;
import com.bxm.localnews.news.model.vo.AdminNewsReply;
import com.bxm.localnews.news.service.AdminNewsReplyService;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-08 [\u7ba1\u7406]\u65b0\u95fb\u7ba1\u7406\u4e2d\u8bc4\u8bba\u7ba1\u7406"}, description="\u65b0\u95fb\u8bc4\u8bba\u7ba1\u7406\uff0c\u5305\u62ec\u65b0\u95fb\u8bc4\u8bba\u7684\u6a21\u62df\u751f\u6210\uff0c\u6dfb\u52a0\uff0c\u5220\u9664")
@RestController
@RequestMapping(value={"manage/news/reply"})
public class AdminNewsReplyController {
    private final AdminNewsReplyService adminNewsReplyService;
    private final NewNewsReplyService newNewsReplyService;

    @Autowired
    public AdminNewsReplyController(AdminNewsReplyService adminNewsReplyService, NewNewsReplyService newNewsReplyService) {
        this.adminNewsReplyService = adminNewsReplyService;
        this.newNewsReplyService = newNewsReplyService;
    }

    @ApiOperation(value="9-08-1 \u6a21\u62df\u8bc4\u8bba\u751f\u6210")
    @PostMapping(value={"/virtual"})
    public Json generate(@RequestBody AdminNewsReplyOriginalParam adminNewsReplyOriginalParam) {
        if (adminNewsReplyOriginalParam.getNewsId() != null) {
            return this.adminNewsReplyService.doGenerateReply(adminNewsReplyOriginalParam);
        }
        return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u65b0\u95fb\u7f16\u53f7");
    }

    @ApiOperation(value="9-08-2 \u65b0\u95fb\u4e0b\u8bc4\u8bba\u5206\u9875")
    @GetMapping(value={"/list"})
    public Json<PageWarper<AdminNewsReply>> queryPage(AdminNewsReplyParam adminNewsReplyParam) {
        return ResultUtil.genSuccessResult((Object)this.adminNewsReplyService.listNewsReply(adminNewsReplyParam));
    }

    @ApiOperation(value="9-08-3 \u8bc4\u8bba\u5220\u9664")
    @PostMapping(value={"/del"})
    public Json del(@RequestBody RemoveReplayParam param) {
        if (param.getNewsId() != null) {
            this.newNewsReplyService.delReply(param.getReplyId(), param.getNewsId());
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)"\u8bf7\u8f93\u5165\u65b0\u95fb\u7f16\u53f7");
    }

    @ApiOperation(value="9-08-4 \u589e\u52a0\u8bc4\u8bba\u56de\u590d")
    @PostMapping(value={"/addCommentReply"})
    public Json addCommentReply(@RequestBody AdminCommentReplyParam adminCommentReplyParam) {
        int result = this.adminNewsReplyService.doAddCommentReply(adminCommentReplyParam);
        return ResultUtil.genSuccessMsg((String)"\u6dfb\u52a0\u8bc4\u8bba\u6210\u529f");
    }

    @ApiOperation(value="9-08-5 \u8bc4\u8bba\u5206\u9875")
    @GetMapping(value={"/allList"})
    public Json<PageWarper<AdminReplyDTOAdmin>> queryAllList(AdminAllReplyParam adminAllReplyParam) {
        return ResultUtil.genSuccessResult((Object)this.adminNewsReplyService.listAllNewsReply(adminAllReplyParam));
    }

    @ApiOperation(value="9-08-6 \u8bc4\u8bba\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbid", required=true), @ApiImplicitParam(name="replyId", value="\u8bc4\u8bbaid", required=true)})
    @GetMapping(value={"/getReplyDetail"})
    public Json<AdminReplyDetailDTO> getReplyDetail(Long newsId, Long replyId) {
        return ResultUtil.genSuccessResult((Object)this.adminNewsReplyService.getReplyDetail(newsId, replyId));
    }

    @ApiOperation(value="'9-08-7 \u5e16\u5b50\u8bc4\u8bba\u72b6\u6001\u7ba1\u7406")
    @PostMapping(value={"statusChange"})
    public ResponseJson statusChange(@RequestBody ReplyStatusChangeParam param) {
        return ResponseJson.build((Message)this.adminNewsReplyService.statusChange(param));
    }
}

