package com.bxm.localnews.news.comment.service;

import com.bxm.localnews.news.model.dto.NewsReplyDTO;
import com.bxm.localnews.news.model.dto.NewsReplyMirrorDTO;
import com.bxm.localnews.news.model.entity.NewsReplyAllCountInfo;
import com.bxm.localnews.news.model.param.NewsReplyParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;

import java.util.Date;
import java.util.List;

/**
 * @author liujia
 * @date 1/15/21 10:42 AM
 **/
public interface CommentFacadeService {
    /**
     * 计算内容显示的评论数量
     * 评论数量需要根据地区、是否仅用户可见进行处理
     *
     * @param newsId   新闻 帖子id
     * @param userId   用户Id
     * @param areaCode 地区编码，如果传递了，则仅显示马甲号评论、地区匹配的评论
     * @return 评论数
     */
    Integer replyNum(Long newsId, Long userId, String areaCode);

    /**
     * 获取帖子下的一条可用热评信息，用于在列表中显示
     *
     * @param postId   帖子ID
     * @param userId   当前用户ID
     * @param areaCode 地区限制，如果热评有地区，并且与当前用户地区不一致则不显示
     * @return 热门评论集合
     */
    List<NewsReplyDTO> getCacheHotReply(Long postId, Long userId, String areaCode);

    void dealSubMirrorDTO(NewsReplyMirrorDTO replay, Long userId, List<Long> replyLikes);

    /**
     * @param list           评论列表
     * @param newsReplyParam 查询参数
     * @param isHotReplies   是否是查询热评列表（非缓存查询）
     * @return
     */
    List<NewsReplyDTO> execReplyLogic(List<NewsReplyDTO> list, NewsReplyParam newsReplyParam, boolean isHotReplies);

    List<NewsReplyDTO> getHotReplays(NewsReplyParam newsReplyParam);

    /**
     * 获取时间区间内未审核的评论数量
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 未审核的评论信息
     */
    List<NewsReplyAllCountInfo> getAuditReplyCount(Date startTime, Date endTime);

    /**
     * 帖子增加马甲号评论
     *
     * @param forumPostVo 帖子信息
     */
    void addPostReply(ForumPostVo forumPostVo);
}
