package com.bxm.localnews.news.comment.impl;

import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.comment.ForumReplyManageService;
import com.bxm.localnews.news.model.param.AdminNewsReplyOriginalParam;
import com.bxm.localnews.news.model.param.AdminNewsReplyOriginalParam.Reply;
import com.bxm.localnews.news.model.param.BatchAddReplyParam;
import com.bxm.localnews.news.service.AdminNewsReplyService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Calendar;
import java.util.Date;
import java.util.stream.Collectors;

import static com.alibaba.fastjson.JSON.toJSON;

/**
 * @author gonzo
 * @date 2020-09-18 14:43
 **/
@Slf4j
@Service
@AllArgsConstructor
public class ForumReplyManageServiceImpl implements ForumReplyManageService {

    private final AdminNewsReplyService adminNewsReplyService;


    @Override
    public Message batchAddReply(BatchAddReplyParam param) {

        if (CollectionUtils.isEmpty(param.getReplyList()) || param.getReplyList().stream()
                .map(BatchAddReplyParam.Reply::getContent)
                .anyMatch(StringUtils::isBlank)) {
            return Message.build(false, "请勿提交空评论");
        }

        log.info("用户: {} 给帖子: {} 增加评论 param: {}", param.getUserId(), param.getForumId(), toJSON(param));

        Date startTime = new Date();

        AdminNewsReplyOriginalParam adminNewsReplyOriginalParam = new AdminNewsReplyOriginalParam();
        // 地方发布
        adminNewsReplyOriginalParam.setDeliveryType(1);
        // 区域code
        adminNewsReplyOriginalParam.setAreaCode(param.getAreaCode());
        adminNewsReplyOriginalParam.setStartTime(startTime);
        // 5分钟
        adminNewsReplyOriginalParam.setEndTime(DateUtils.addField(startTime, Calendar.MINUTE, 5));
        // 帖子id
        adminNewsReplyOriginalParam.setNewsId(param.getForumId());
        // 转换评论对象
        adminNewsReplyOriginalParam.setList(param.getReplyList().stream().map(this::convert).collect(Collectors.toList()));
        // 操作人id
        adminNewsReplyOriginalParam.setAddAppUserId(param.getUserId());

        // 调用原有的添加评论方法
        Json res = adminNewsReplyService.doGenerateReply(adminNewsReplyOriginalParam);
        return Message.build(res.success(), res.getErrorMsg());
    }

    private Reply convert(BatchAddReplyParam.Reply sourceReply) {
        Reply reply = new Reply();
        reply.setContent(sourceReply.getContent());
        return reply;
    }
}
