package com.bxm.localnews.news.convert;

import com.bxm.localnews.integration.VirtualUserIntegrationService;
import com.bxm.localnews.news.domain.AdminNewsReplyMapper;
import com.bxm.localnews.news.domain.AdminUserReplyMapper;
import com.bxm.localnews.news.enums.Converter;
import com.bxm.localnews.news.model.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.news.model.param.AdminCommentReplyParam;
import com.bxm.localnews.news.model.vo.AdminNewsReply;
import com.bxm.newidea.component.service.BaseService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Objects;

import static org.apache.commons.lang3.StringUtils.isBlank;

@Component
@AllArgsConstructor
public class CommentReplyConverter extends BaseService implements Converter<AdminCommentReplyParam, AdminNewsReply> {
    private final AdminNewsReplyMapper adminNewsReplyMapper;

    private final AdminUserReplyMapper adminUserReplyMapper;

    private final VirtualUserIntegrationService virtualUserIntegrationService;


    @Override
    public AdminNewsReply convert(AdminCommentReplyParam param) {
        String headImg = param.getVirtualHeadImg();
        String nickName = param.getVirtualNickName();

        if (isBlank(headImg) || isBlank(nickName)) {
            // 根据id数据库查询
            VirtualUserOverviewDTO virtualUser = virtualUserIntegrationService.getByIdCacheFirst(param.getVirtualUserId());

            if (null != virtualUser) {
                headImg = virtualUser.getHeadImg();
                nickName = virtualUser.getNickname();
            }
        }


        AdminNewsReply parentReply = adminNewsReplyMapper.selectByPrimaryKey(param.getParentReplyId(), param.getNewsId());
        AdminNewsReply adminNewsReply = new AdminNewsReply();
        //评论设置为不展示
        adminNewsReply.setId(nextId());
        adminNewsReply.setStatus((byte) 0);
        adminNewsReply.setDeleteFlag((byte) 0);
        adminNewsReply.setInteractiveCount(0);
        adminNewsReply.setLikeCount(0);
        adminNewsReply.setParentId(parentReply.getId());
        adminNewsReply.setType(parentReply.getType());
        adminNewsReply.setParentUserId(parentReply.getUserId());
        adminNewsReply.setParentHeadImg(parentReply.getHeadImg());
        adminNewsReply.setParentUserNickname(parentReply.getUserNickname());
        adminNewsReply.setNewsId(param.getNewsId());
        adminNewsReply.setHeadImg(headImg);
        adminNewsReply.setUserId(param.getVirtualUserId());
        adminNewsReply.setAddTime(param.getReplyTime());
        adminNewsReply.setUserNickname(nickName);
        adminNewsReply.setReplyContent(param.getReplyContent());
        // 设置为马甲号评论
        adminNewsReply.setReplyUserType((byte) 1);
        //根据上级评论id判断newsreply的level,rootId,
        if (parentReply.getLevel() == 0) {
            adminNewsReply.setLevel((byte) 1);
            adminNewsReply.setRootId(parentReply.getId());
        } else if (parentReply.getLevel() == 1) {
            adminNewsReply.setLevel((byte) 2);
            adminNewsReply.setRootId(parentReply.getRootId());
        } else if (parentReply.getLevel() == 2) {
            adminNewsReply.setLevel((byte) 2);
            adminNewsReply.setRootId(parentReply.getRootId());
        }
        //更新上级评论的马甲号互动
        if (Objects.isNull(parentReply.getVestInteract()) || parentReply.getVestInteract() == 0) {
            adminNewsReplyMapper.updateVestInteractById(parentReply.getId(), parentReply.getNewsId());
            adminUserReplyMapper.updateVestInteractById(parentReply.getId(), parentReply.getUserId());
        }

        return adminNewsReply;
    }
}
