package com.bxm.localnews.news.service;

import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.model.dto.AdminReplyDTOAdmin;
import com.bxm.localnews.news.model.dto.AdminReplyDetailDTO;
import com.bxm.localnews.news.model.param.*;
import com.bxm.localnews.news.model.vo.AdminNewsReply;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.bo.Message;

public interface AdminNewsReplyService {

    /**
     * 用途：生成虚拟评论
     *
     * @param adminNewsReplyOriginalParam
     */
    Json doGenerateReply(AdminNewsReplyOriginalParam adminNewsReplyOriginalParam);

    /**
     * 用途：分页查询新闻下的评论
     *
     * @param adminNewsReplyParam
     * @return
     */
    PageWarper<AdminNewsReply> listNewsReply(AdminNewsReplyParam adminNewsReplyParam);

    /**
     * 添加评论回复
     *
     * @param adminCommentReplyParam
     * @return
     */
    int doAddCommentReply(AdminCommentReplyParam adminCommentReplyParam);

    PageWarper<AdminReplyDTOAdmin> listAllNewsReply(AdminAllReplyParam adminAllReplyParam);

    /**
     * 帖子评论状态管理
     *
     * @param param 状态等参数
     * @return 操作结果
     */
    Message statusChange(ReplyStatusChangeParam param);

    AdminReplyDetailDTO getReplyDetail(Long newsId, Long replyId);
}
