package com.bxm.localnews.news.service;

import com.bxm.localnews.news.model.param.AdminReplyLibraryCategoryParam;
import com.bxm.localnews.news.model.vo.AdminReplyLibraryCategory;
import com.bxm.localnews.news.vo.PageWarper;

/**
 * 评论库类别管理服务
 */
public interface AdminReplyLibraryCategoryService {

    /**
     * 分页查询评论类别
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<AdminReplyLibraryCategory> getList(AdminReplyLibraryCategoryParam param);

    /**
     * 获取评论类别详情
     *
     * @param id
     * @return
     */
    AdminReplyLibraryCategory selectByPrimaryKey(Long id);

    /**
     * 新增评论类别
     *
     * @param adminReplyLibraryCategory
     * @return
     */
    int insert(AdminReplyLibraryCategory adminReplyLibraryCategory);

    /**
     * 编辑评论类别
     *
     * @param adminReplyLibraryCategory
     * @return
     */
    int updateByPrimaryKey(AdminReplyLibraryCategory adminReplyLibraryCategory);

    /**
     * 删除评论类别
     *
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

}
