package com.bxm.localnews.news.service;

import com.bxm.localnews.news.model.param.AdminReplyLibraryParam;
import com.bxm.localnews.news.model.param.AdminReplyOriginalParam;
import com.bxm.localnews.news.model.param.ReplyCategoryParam;
import com.bxm.localnews.news.model.vo.AdminReplyLibrary;
import com.bxm.localnews.news.vo.PageWarper;

import java.util.List;

/**
 * 评论库管理服务
 */
public interface AdminReplyLibraryService {

    /**
     * 分页查询评论
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<AdminReplyLibrary> getList(AdminReplyLibraryParam param);

    /**
     * 获取评论详情
     *
     * @param id
     * @return
     */
    AdminReplyLibrary selectByPrimaryKey(Long id);

    /**
     * 批量新增评论
     *
     * @param adminReplyLibraryList
     * @return
     */
    int batchInsert(List<AdminReplyLibrary> adminReplyLibraryList);

    /**
     * 编辑评论
     *
     * @param adminReplyLibrary
     * @return
     */
    int updateByPrimaryKey(AdminReplyLibrary adminReplyLibrary);

    /**
     * 删除评论
     *
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

    /**
     * 模拟评论生成
     *
     * @param param
     * @return
     */
    void generateVirtualReply(AdminReplyOriginalParam param);

    List<AdminReplyLibrary> getReplyByCategoryId(ReplyCategoryParam param);
}
