package com.bxm.localnews.news.service.impl;

import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.param.UserWarmActionParam;
import com.bxm.localnews.integration.*;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.MemoryCacheKey;
import com.bxm.localnews.news.convert.CommentReplyConverter;
import com.bxm.localnews.news.domain.AdminAllReplyMapper;
import com.bxm.localnews.news.domain.AdminNewsReplyMapper;
import com.bxm.localnews.news.domain.AdminUserReplyMapper;
import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.event.ReplyAccessApplicationEvent;
import com.bxm.localnews.news.facade.service.ForumPostInnerService;
import com.bxm.localnews.news.facade.service.ForumPostTotalFacadeService;
import com.bxm.localnews.news.model.dto.AdminReplyDTOAdmin;
import com.bxm.localnews.news.model.dto.AdminReplyDetailDTO;
import com.bxm.localnews.news.model.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.news.model.entity.ForumPostTotalEntity;
import com.bxm.localnews.news.model.param.*;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminNewsReply;
import com.bxm.localnews.news.model.vo.VirtualUser;
import com.bxm.localnews.news.service.AdminNewsReplyService;
import com.bxm.localnews.news.util.JudgeUtil;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.github.pagehelper.PageHelper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

import static com.bxm.localnews.news.constant.GlobalConstant.GLOBAL_NAME;
import static com.bxm.localnews.news.enums.ReplyStatusEnum.MANAGE_DELETE;
import static com.bxm.localnews.news.enums.ReplyStatusEnum.USER_DELETE;
import static java.util.Objects.nonNull;
import static org.apache.commons.lang3.RandomUtils.nextLong;

@Service
@AllArgsConstructor
@Slf4j
public class AdminNewsReplyServiceImpl implements AdminNewsReplyService {

    private AdminNewsReplyMapper adminNewsReplyMapper;

    private AdminUserReplyMapper adminUserReplyMapper;

    private CommentReplyConverter commentReplyConverter;

    private LocationIntegrationService locationIntegrationService;

    private AdminAllReplyMapper adminAllReplyMapper;

    private VirtualUserIntegrationService virtualUserIntegrationService;

    private UserIntegrationService userIntegrationService;

    private CacheHolder cacheHolder;

    private PushMsgService pushMsgService;

    private ForumProperties forumProperties;

    private UserWarmIntegrationService userWarmIntegrationService;

    private ForumPostTotalFacadeService forumPostTotalFacadeService;

    private ForumPostInnerService forumPostInnerService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Json doGenerateReply(AdminNewsReplyOriginalParam adminNewsReplyOriginalParam) {

        if (Objects.isNull(adminNewsReplyOriginalParam.getDeliveryType())
                // 如果是地方 则必须选择区域编码
                || (adminNewsReplyOriginalParam.getDeliveryType() == 1
                && StringUtils.isBlank(adminNewsReplyOriginalParam.getAreaCode()))) {
            return ResultUtil.genFailedResult("请先选择区域，才能选择区域马甲进行评论");
        }

        Long newsId = adminNewsReplyOriginalParam.getNewsId();
        List<Long> userIdList = adminNewsReplyMapper.selectUserFromReply(newsId);
        List<AdminNewsReplyOriginalParam.Reply> replyList = adminNewsReplyOriginalParam.getList();

        // 前端的area code 111,222,333
        List<String> areaCode = Arrays.asList(adminNewsReplyOriginalParam.getAreaCode().split(","));
        log.info("选择马甲库的区域信息: deliveryType: {}, areaCode:{}", adminNewsReplyOriginalParam.getDeliveryType(), areaCode);

        VirtualUserRandomQueryParam randomQueryParam = new VirtualUserRandomQueryParam();
        randomQueryParam.setNum(replyList.size() + 10);
        randomQueryParam.setType((byte) 1);
        randomQueryParam.setExitUserId(userIdList);
        randomQueryParam.setDeliveryType(adminNewsReplyOriginalParam.getDeliveryType());
        randomQueryParam.setIncludeAreaCodes(areaCode);
        randomQueryParam.setSex(adminNewsReplyOriginalParam.getSex());

        List<VirtualUser> virtualUserList = virtualUserIntegrationService.getRandom(randomQueryParam);

        if (CollectionUtils.isEmpty(virtualUserList)) {
            // 查找不到可用的马甲号进行评论时
            return ResultUtil.genFailedResult(StringUtils.join("选择的区域: ",
                    adminNewsReplyOriginalParam.getDeliveryType() == 0 ? GLOBAL_NAME : adminNewsReplyOriginalParam.getAreaCode(),
                    " 下查找不到可用的马甲号进行评论"));
        }

        long startTime = adminNewsReplyOriginalParam.getStartTime().getTime();
        long endTime = adminNewsReplyOriginalParam.getEndTime().getTime();

        if (startTime > endTime) {
            return ResultUtil.genFailedResult("开始时间在结束时间之后，无法添加");
        }

        int index = 0;
        int virtualUserCount = virtualUserList.size();
        for (AdminNewsReplyOriginalParam.Reply reply : replyList) {

            if (index > virtualUserCount - 1) {
                index = (int) (Math.random() * virtualUserCount);

            }

            // 获取马甲号
            VirtualUser virtualUser;
            if (nonNull(reply.getVirtualUserId())) {
                // 如果传了id 则使用自带的
                VirtualUserOverviewDTO queryVirtualUser = virtualUserIntegrationService.getByIdCacheFirst(reply.getVirtualUserId());
                if (null == queryVirtualUser) {
                    virtualUser = virtualUserList.get(index);
                } else {
                    virtualUser = convert(queryVirtualUser);
                }
            } else {
                virtualUser = virtualUserList.get(index);
            }

            long indexTime = nextLong(startTime, endTime);

            AdminNewsReply adminNewsReply = new AdminNewsReply();
            adminNewsReply.setAddTime(new Date(indexTime));
            adminNewsReply.setDeleteFlag((byte) 0);
            adminNewsReply.setHeadImg(virtualUser.getHeadImg());
            adminNewsReply.setId(SequenceHolder.nextLongId());
            adminNewsReply.setLevel((byte) 0);
            adminNewsReply.setLikeCount(0);
            adminNewsReply.setNewsId(adminNewsReplyOriginalParam.getNewsId());
            adminNewsReply.setReplyContent(reply.getContent());
            //如果是帖子
            if (JudgeUtil.isPost(newsId)) {
                adminNewsReply.setType((byte) 3);
                //如果是新闻
            } else {
                adminNewsReply.setType((byte) 1);
            }
            adminNewsReply.setParentId(0L);
            //都设置为待展示，等待扫描
            adminNewsReply.setStatus((byte) 0);
            adminNewsReply.setUserId(virtualUser.getId());
            adminNewsReply.setUserNickname(virtualUser.getNickname());
            adminNewsReply.setInteractiveCount(0);
            adminNewsReply.setRootId(0L);
            adminNewsReply.setAddAppUserId(adminNewsReplyOriginalParam.getAddAppUserId());
            // 马甲号增加的评论
            adminNewsReply.setReplyUserType((byte) 1);
            adminNewsReplyMapper.insertSelective(adminNewsReply);
            adminUserReplyMapper.insertUserReplySelective(adminNewsReply);
            index++;
        }

        long count = adminNewsReplyMapper.count(adminNewsReplyOriginalParam.getNewsId());

        log.info("虚拟评论生成，已有评论数:{},新闻/帖子id:{}", count, adminNewsReplyOriginalParam.getNewsId());

        //如果是帖子
        if (JudgeUtil.isPost(newsId)) {
            ForumPostTotalEntity totalEntity = ForumPostTotalEntity.builder()
                    .postId(adminNewsReplyOriginalParam.getNewsId())
                    .commentCount(count)
                    .build();
            forumPostTotalFacadeService.updateField(totalEntity);
        }

        removeReplyCache(adminNewsReplyOriginalParam.getNewsId());

        return ResultUtil.genSuccessMsg();
    }

    private void removeReplyCache(Long newsId) {
        if (null != newsId) {
            cacheHolder.sendEvictCmd(MemoryCacheKey.HOT_REPLY_CACHE, newsId);
            cacheHolder.sendEvictCmd(MemoryCacheKey.REPLY_COUNT_CACHE, newsId);
        }
    }

    private VirtualUser convert(VirtualUserOverviewDTO virtualUserOverviewDTO) {
        VirtualUser user = new VirtualUser();
        user.setId(virtualUserOverviewDTO.getId());
        user.setNickname(virtualUserOverviewDTO.getNickname());
        user.setHeadImg(virtualUserOverviewDTO.getHeadImg());
        return user;
    }

    @Override
    public PageWarper<AdminNewsReply> listNewsReply(AdminNewsReplyParam adminNewsReplyParam) {
        PageWarper<AdminNewsReply> newsReplyPageWarper = new PageWarper<>(adminNewsReplyMapper.queryByPageSize(adminNewsReplyParam));
        List<AdminNewsReply> adminNewsReplyList = newsReplyPageWarper.getList();
        if (CollectionUtils.isNotEmpty(adminNewsReplyList)) {
            adminNewsReplyList.parallelStream().forEach(e -> {
                e.setIsVirtualParentUser((byte) ((null != e.getParentUserId() && virtualUserIntegrationService.exists(e.getParentUserId())) ? 1 : 0));
                e.setIsVirtualUser((byte) ((null != e.getUserId() && virtualUserIntegrationService.exists(e.getUserId())) ? 1 : 0));

                // 获取缓存的用户信息
                UserBean replyUserInfo = userIntegrationService.selectUserFromCache(e.getUserId());
                Byte sex = replyUserInfo.getSex();
                if (Objects.isNull(sex)) {
                    e.setUserNickname(e.getUserNickname() + "(女)");
                } else {
                    if (1 == sex) {
                        e.setUserNickname(e.getUserNickname() + "(男)");
                    } else if (2 == sex) {
                        e.setUserNickname(e.getUserNickname() + "(女)");
                    } else if (0 == sex) {
                        e.setUserNickname(e.getUserNickname() + "(未知)");
                    }
                }
            });
        }

        return newsReplyPageWarper;
    }

    @Override
    public int doAddCommentReply(AdminCommentReplyParam adminCommentReplyParam) {
        //参数转化成实体
        AdminNewsReply adminNewsReply = commentReplyConverter.convert(adminCommentReplyParam);
        //用户评论表
        adminUserReplyMapper.insertUserReplySelective(adminNewsReply);
        //新闻评论表
        int result = adminNewsReplyMapper.insertSelective(adminNewsReply);

        if (JudgeUtil.isPost(adminNewsReply.getNewsId())) {
            removeReplyCache(adminNewsReply.getNewsId());
        }

        return result;
    }

    @Override
    public PageWarper<AdminReplyDTOAdmin> listAllNewsReply(AdminAllReplyParam adminAllReplyParam) {
        //兼容客户端搜索评论的正常状态
        if (nonNull(adminAllReplyParam.getIsUserDelete()) && adminAllReplyParam.getIsUserDelete() == 2) {
            adminAllReplyParam.setIsUserDelete(null);
            adminAllReplyParam.setDeleteFlag((byte) 0);
        }

        // 兼容一下 搜索状态
        if (nonNull(adminAllReplyParam.getCommentStatus())) {
            if (Objects.equals(adminAllReplyParam.getCommentStatus(), USER_DELETE.getCode())) {
                adminAllReplyParam.setCommentStatus(null);
                adminAllReplyParam.setDeleteFlag((byte) 1);
                adminAllReplyParam.setIsUserDelete((byte) 1);
            } else if (Objects.equals(adminAllReplyParam.getCommentStatus(), MANAGE_DELETE.getCode())) {
                adminAllReplyParam.setCommentStatus(null);
                adminAllReplyParam.setIsUserDelete((byte) 0);
                adminAllReplyParam.setDeleteFlag((byte) 1);
            } else {
                adminAllReplyParam.setDeleteFlag((byte) 0);
            }
        }
        PageHelper.startPage(adminAllReplyParam.getPageNum(),adminAllReplyParam.getPageSize());
        PageWarper<AdminReplyDTOAdmin> adminReplyDTOAdminPageWarper = new PageWarper<>(adminAllReplyMapper.listAllNewsReply(adminAllReplyParam));
        List<Long> postIdList = adminReplyDTOAdminPageWarper.getList().stream().map(AdminReplyDTOAdmin::getNewsId).collect(Collectors.toList());
        Map<Long, List<String>> postRelationMap = forumPostInnerService.queryPostRelation(postIdList);

        adminReplyDTOAdminPageWarper.getList().forEach(replyInfo -> {
            if (StringUtils.isNotEmpty(replyInfo.getAreaCode())) {
                List<String> areaCodeList = postRelationMap.get(replyInfo.getNewsId());
                replyInfo.setAreaDetail(locationIntegrationService.batchGetDetailJson(areaCodeList));
            }

            replyInfo.setLinkUrl(ProtocolFactory.forumPost().outer()
                    .noExtend()
                    .userId(replyInfo.getUserId())
                    .postId(replyInfo.getNewsId())
                    .debug()
                    .build());


            replyInfo.setIsVirtualParentUser((byte) ((null != replyInfo.getParentUserId() && virtualUserIntegrationService.exists(replyInfo.getParentUserId())) ? 1 : 0));
            replyInfo.setIsVirtualUser((byte) ((null != replyInfo.getUserId() && virtualUserIntegrationService.exists(replyInfo.getUserId())) ? 1 : 0));

            // 状态兼容
            replyInfo.setCommentStatus(replyInfo.getStatus());
            if (nonNull(replyInfo.getDeleteFlag()) && replyInfo.getDeleteFlag().intValue() == 1) {
                replyInfo.setCommentStatus((Objects.equals(replyInfo.getIsUserDelete(), (byte) 1)
                        ? USER_DELETE.getCode() : MANAGE_DELETE.getCode()));
            }
        });
        return adminReplyDTOAdminPageWarper;
    }

    @Override
    public Message statusChange(ReplyStatusChangeParam param) {

        AdminNewsReply adminNewsReply = adminNewsReplyMapper.selectByPrimaryKey(param.getReplyId(), param.getNewsId());

        if (Objects.isNull(adminNewsReply)) {
            return Message.build(false, "数据不存在");
        }

        ReplyStatusEnum statusEnum = null;
        if (Objects.equals(param.getOptionType(), (byte) 1)) {
            statusEnum = ReplyStatusEnum.IS_SHOW;
            handleWarmMedalCounterData(param.getCurrentUserId());
        } else if (Objects.equals(param.getOptionType(), (byte) 2)) {
            statusEnum = ReplyStatusEnum.REFUSE;
        } else if (Objects.equals(param.getOptionType(), (byte) 3)) {
            statusEnum = ReplyStatusEnum.SELF;
        } else {
            return Message.build(false, "不支持的操作");
        }

        adminNewsReplyMapper.updateStatus(param.getReplyId(), param.getNewsId(), statusEnum.getCode());

        if (Objects.equals(statusEnum, ReplyStatusEnum.REFUSE)) {

            // 发推送给用户 告诉被拒绝了
            pushMsgService.pushReplyDeleteAndRejectMsg(adminNewsReply.getReplyContent(),
                    adminNewsReply.getUserId(),
                    forumProperties.getOfficialRulePostId());

        } else if (Objects.equals(statusEnum, ReplyStatusEnum.IS_SHOW)) {
            // 判断上一次是否是待审核
            if (Objects.equals(adminNewsReply.getStatus(), ReplyStatusEnum.WAIT_REVIEW.getCode())) {
                // 发一个事件 让别的模块的代码进行推送
                SpringContextHolder.getApplicationContext()
                        .publishEvent(new ReplyAccessApplicationEvent(adminNewsReply.getId(), adminNewsReply.getNewsId()));

            }
        }

        // 清除评论数量的缓存
        cacheHolder.sendEvictCmd(MemoryCacheKey.REPLY_COUNT_CACHE, param.getNewsId());
        return Message.build();
    }

    @Override
    public AdminReplyDetailDTO getReplyDetail(Long newsId, Long replyId) {
        AdminNewsReply adminNewsReply = adminNewsReplyMapper.selectByPrimaryKey(replyId, newsId);
        //判断评论是否是跟评论,不是则找出根评论
        if (adminNewsReply.getRootId() != 0) {
            adminNewsReply = adminNewsReplyMapper.selectByPrimaryKey(adminNewsReply.getRootId(), newsId);
        }
        adminNewsReply.setIsVirtualParentUser((byte) ((null != adminNewsReply.getParentUserId() && virtualUserIntegrationService.exists(adminNewsReply.getParentUserId())) ? 1 : 0));
        adminNewsReply.setIsVirtualUser((byte) ((null != adminNewsReply.getUserId() && virtualUserIntegrationService.exists(adminNewsReply.getUserId())) ? 1 : 0));

        AdminReplyDetailDTO replyDetailDTO = new AdminReplyDetailDTO();
        BeanUtils.copyProperties(adminNewsReply, replyDetailDTO);
        //查找根评论
        List<AdminNewsReply> childs = adminNewsReplyMapper.selectByRootId(adminNewsReply.getId(), adminNewsReply.getNewsId());
        childs.forEach(e -> {
            e.setIsVirtualParentUser((byte) ((null != e.getParentUserId() && virtualUserIntegrationService.exists(e.getParentUserId())) ? 1 : 0));
            e.setIsVirtualUser((byte) ((null != e.getUserId() && virtualUserIntegrationService.exists(e.getUserId())) ? 1 : 0));
        });
        replyDetailDTO.setList(childs);
        //组装帖子或者新闻
        Byte type = adminNewsReply.getType();
        if (type == 3) {
            AdminForumPost adminForumPost = forumPostInnerService.getAdminForumPost(adminNewsReply.getNewsId());
            adminForumPost.setLinkUrl(ProtocolFactory.forumPost().outer().postId(adminForumPost.getId()).userId(adminForumPost.getUserId()).build());
            replyDetailDTO.setForumPost(adminForumPost);
        }
        return replyDetailDTO;
    }


    /**
     * 处理温暖值和勋章统计数据
     *
     * @param currentUserId 当前用户id
     */
    private void handleWarmMedalCounterData(Long currentUserId) {
        UserWarmActionParam userWarmActionParam = UserWarmActionParam.builder()
                .userId(currentUserId)
                .warmRuleEnum(WarmRuleEnum.COMMENT)
                .build();
        userWarmIntegrationService.updateWarm(userWarmActionParam);
    }
}
