package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.domain.AdminReplyLibraryMapper;
import com.bxm.localnews.news.model.param.AdminNewsReplyOriginalParam;
import com.bxm.localnews.news.model.param.AdminReplyLibraryParam;
import com.bxm.localnews.news.model.param.AdminReplyOriginalParam;
import com.bxm.localnews.news.model.param.ReplyCategoryParam;
import com.bxm.localnews.news.model.vo.AdminReplyLibrary;
import com.bxm.localnews.news.model.vo.AdminReplyLibraryCategory;
import com.bxm.localnews.news.service.AdminNewsReplyService;
import com.bxm.localnews.news.service.AdminReplyLibraryService;
import com.bxm.localnews.news.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class AdminReplyLibraryServiceImpl implements AdminReplyLibraryService {

    @Resource
    private AdminReplyLibraryMapper adminReplyLibraryMapper;

    @Resource
    private AdminNewsReplyService adminNewsReplyService;

    @Override
    public PageWarper<AdminReplyLibrary> getList(AdminReplyLibraryParam param) {
        return new PageWarper<>(adminReplyLibraryMapper.getList(param));
    }

    @Override
    public AdminReplyLibrary selectByPrimaryKey(Long id) {
        return adminReplyLibraryMapper.selectByPrimaryKey(id);
    }

    @Override
    public int batchInsert(List<AdminReplyLibrary> adminReplyLibraryList) {
        if (CollectionUtils.isEmpty(adminReplyLibraryList)) {
            return 0;
        }

        return adminReplyLibraryMapper.batchInsert(adminReplyLibraryList);
    }

    @Override
    public int updateByPrimaryKey(AdminReplyLibrary adminReplyLibrary) {
        return adminReplyLibraryMapper.updateByPrimaryKey(adminReplyLibrary);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return adminReplyLibraryMapper.deleteByPrimaryKey(id);
    }

    @Override
    public void generateVirtualReply(AdminReplyOriginalParam param) {
        if (null == param || CollectionUtils.isEmpty(param.getAdminReplyLibraryCategoryList())) {
            return;
        }

        List<AdminNewsReplyOriginalParam.Reply> replyList = new ArrayList<>();
        for (AdminReplyLibraryCategory adminReplyLibraryCategory : param.getAdminReplyLibraryCategoryList()) {
            List<String> replyStringList = adminReplyLibraryMapper.getRandList(adminReplyLibraryCategory.getId(), adminReplyLibraryCategory.getReplyCount());

            if (CollectionUtils.isNotEmpty(replyStringList)) {
                for (String replyStr : replyStringList) {
                    AdminNewsReplyOriginalParam.Reply reply = new AdminNewsReplyOriginalParam.Reply();
                    reply.setContent(replyStr);
                    replyList.add(reply);
                }
            }
        }

        AdminNewsReplyOriginalParam replyParam = new AdminNewsReplyOriginalParam();
        replyParam.setNewsId(param.getNewsId());
        replyParam.setStartTime(param.getStartTime());
        replyParam.setEndTime(param.getEndTime());
        replyParam.setList(replyList);
        adminNewsReplyService.doGenerateReply(replyParam);
    }

    @Override
    public List<AdminReplyLibrary> getReplyByCategoryId(ReplyCategoryParam param) {
        return adminReplyLibraryMapper.getRandListByCategoryId(param);
    }
}
