package com.bxm.localnews.news.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.news.service.HotReplayService;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 定期评论设置为热门评论
 *
 * @author liujia
 * @date 1/22/21 3:51 PM
 **/
@Component
public class AutoSetHotReplayTask implements ISimplifyElasticJob {

    @Resource
    private HotReplayService hotReplayService;

    @Override
    public String cron() {
        return "0 0/10 * * * ?";
    }

    @Override
    public String description() {
        return "定期评论设置为热门评论";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        hotReplayService.calHotReplay();
    }
}
