package com.bxm.localnews.news.utils;

import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.model.vo.NewsReplyBaseVO;
import com.bxm.newidea.component.tools.StringUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.bxm.localnews.news.enums.ReplyStatusEnum.IS_SHOW;
import static com.bxm.localnews.news.enums.ReplyStatusEnum.SELF;

/**
 * @author liujia
 * @date 1/22/21 3:42 PM
 **/
public class CommentUtil {

    private CommentUtil() {
    }

    /**
     * 过滤哪些仅用户可见的评论
     * 如果是仅当前用户可见的评论，则匹配用户ID
     *
     * @param list
     * @param userId
     * @return
     */
    public static <T extends NewsReplyBaseVO> List<T> filter(List<T> list, Long userId) {
        return list.stream().filter(replay -> {
            return replay.getDisplayOwner() == 0 ||
                    (replay.getDisplayOwner() == 1
                            && Objects.equals(userId, replay.getUserId()));
        }).collect(Collectors.toList());
    }

    public static <T extends NewsReplyBaseVO> List<T> filter(List<T> allReplayList, Long userId, String areaCode) {
        // 过滤仅用户可见的数据
        if (null != userId) {
            allReplayList = allReplayList.stream().filter(reply -> {
                if (Objects.equals(reply.getDisplayOwner(), 0) && !Objects.equals(reply.getStatus(), SELF.getCode())) {
                    return true;
                }

                return (Objects.equals(reply.getDisplayOwner(), 1) && Objects.equals(userId, reply.getUserId()))
                        || (Objects.equals(reply.getStatus(), SELF.getCode()) && Objects.equals(userId, reply.getUserId()));
            }).collect(Collectors.toList());
        }

        // 过滤带有地区属性的评论
        if (areaCode != null) {
            allReplayList = allReplayList.stream().filter(reply -> {
                // 马甲号的评论忽略地区熟悉
                if (Objects.equals(reply.getReplyUserType(), 1)) {
                    return true;
                }

                return StringUtils.isBlank(reply.getAreaCode()) || StringUtils.equals(reply.getAreaCode(), areaCode);
            }).collect(Collectors.toList());
        }

        // 二级评论处理，如果二级评论的上级不显示(前面被过滤了)，下级也过滤掉
        List<T> copyList = allReplayList;
        allReplayList = allReplayList.stream().filter(reply -> {
            if (Objects.equals(reply.getParentId(), 0L)) {
                return true;
            }

            return copyList.stream().anyMatch(parentReply -> Objects.equals(parentReply.getId(), reply.getParentId()));
        }).collect(Collectors.toList());

        return allReplayList;
    }
}
