/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.comment.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.comment.ForumReplyManageService;
import com.bxm.localnews.news.model.param.AdminNewsReplyOriginalParam;
import com.bxm.localnews.news.model.param.BatchAddReplyParam;
import com.bxm.localnews.news.service.AdminNewsReplyService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ForumReplyManageServiceImpl
implements ForumReplyManageService {
    private static final Logger log = LoggerFactory.getLogger(ForumReplyManageServiceImpl.class);
    private final AdminNewsReplyService adminNewsReplyService;

    @Override
    public Message batchAddReply(BatchAddReplyParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getReplyList()) || param.getReplyList().stream().map(BatchAddReplyParam.Reply::getContent).anyMatch(StringUtils::isBlank)) {
            return Message.build((boolean)false, (String)"\u8bf7\u52ff\u63d0\u4ea4\u7a7a\u8bc4\u8bba");
        }
        log.info("\u7528\u6237: {} \u7ed9\u5e16\u5b50: {} \u589e\u52a0\u8bc4\u8bba param: {}", new Object[]{param.getUserId(), param.getForumId(), JSON.toJSON((Object)param)});
        Date startTime = new Date();
        AdminNewsReplyOriginalParam adminNewsReplyOriginalParam = new AdminNewsReplyOriginalParam();
        adminNewsReplyOriginalParam.setDeliveryType(Integer.valueOf(1));
        adminNewsReplyOriginalParam.setAreaCode(param.getAreaCode());
        adminNewsReplyOriginalParam.setStartTime(startTime);
        adminNewsReplyOriginalParam.setEndTime(DateUtils.addField((Date)startTime, (int)12, (int)5));
        adminNewsReplyOriginalParam.setNewsId(param.getForumId());
        adminNewsReplyOriginalParam.setList(param.getReplyList().stream().map(this::convert).collect(Collectors.toList()));
        adminNewsReplyOriginalParam.setAddAppUserId(param.getUserId());
        Json res = this.adminNewsReplyService.doGenerateReply(adminNewsReplyOriginalParam);
        return Message.build((boolean)res.success(), (String)res.getErrorMsg());
    }

    private AdminNewsReplyOriginalParam.Reply convert(BatchAddReplyParam.Reply sourceReply) {
        AdminNewsReplyOriginalParam.Reply reply = new AdminNewsReplyOriginalParam.Reply();
        reply.setContent(sourceReply.getContent());
        return reply;
    }

    public ForumReplyManageServiceImpl(AdminNewsReplyService adminNewsReplyService) {
        this.adminNewsReplyService = adminNewsReplyService;
    }
}

