/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.convert;

import com.bxm.localnews.integration.VirtualUserIntegrationService;
import com.bxm.localnews.news.domain.AdminNewsReplyMapper;
import com.bxm.localnews.news.domain.AdminUserReplyMapper;
import com.bxm.localnews.news.enums.Converter;
import com.bxm.localnews.news.model.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.news.model.param.AdminCommentReplyParam;
import com.bxm.localnews.news.model.vo.AdminNewsReply;
import com.bxm.newidea.component.service.BaseService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CommentReplyConverter
extends BaseService
implements Converter<AdminCommentReplyParam, AdminNewsReply> {
    private final AdminNewsReplyMapper adminNewsReplyMapper;
    private final AdminUserReplyMapper adminUserReplyMapper;
    private final VirtualUserIntegrationService virtualUserIntegrationService;

    public AdminNewsReply convert(AdminCommentReplyParam param) {
        VirtualUserOverviewDTO virtualUser;
        String headImg = param.getVirtualHeadImg();
        String nickName = param.getVirtualNickName();
        if ((StringUtils.isBlank((CharSequence)headImg) || StringUtils.isBlank((CharSequence)nickName)) && null != (virtualUser = this.virtualUserIntegrationService.getByIdCacheFirst(param.getVirtualUserId()))) {
            headImg = virtualUser.getHeadImg();
            nickName = virtualUser.getNickname();
        }
        AdminNewsReply parentReply = this.adminNewsReplyMapper.selectByPrimaryKey(param.getParentReplyId(), param.getNewsId());
        AdminNewsReply adminNewsReply = new AdminNewsReply();
        adminNewsReply.setId(Long.valueOf(this.nextId()));
        adminNewsReply.setStatus(Byte.valueOf((byte)0));
        adminNewsReply.setDeleteFlag(Byte.valueOf((byte)0));
        adminNewsReply.setInteractiveCount(Integer.valueOf(0));
        adminNewsReply.setLikeCount(Integer.valueOf(0));
        adminNewsReply.setParentId(parentReply.getId());
        adminNewsReply.setType(parentReply.getType());
        adminNewsReply.setParentUserId(parentReply.getUserId());
        adminNewsReply.setParentHeadImg(parentReply.getHeadImg());
        adminNewsReply.setParentUserNickname(parentReply.getUserNickname());
        adminNewsReply.setNewsId(param.getNewsId());
        adminNewsReply.setHeadImg(headImg);
        adminNewsReply.setUserId(param.getVirtualUserId());
        adminNewsReply.setAddTime(param.getReplyTime());
        adminNewsReply.setUserNickname(nickName);
        adminNewsReply.setReplyContent(param.getReplyContent());
        adminNewsReply.setReplyUserType(Byte.valueOf((byte)1));
        if (parentReply.getLevel() == 0) {
            adminNewsReply.setLevel(Byte.valueOf((byte)1));
            adminNewsReply.setRootId(parentReply.getId());
        } else if (parentReply.getLevel() == 1) {
            adminNewsReply.setLevel(Byte.valueOf((byte)2));
            adminNewsReply.setRootId(parentReply.getRootId());
        } else if (parentReply.getLevel() == 2) {
            adminNewsReply.setLevel(Byte.valueOf((byte)2));
            adminNewsReply.setRootId(parentReply.getRootId());
        }
        if (Objects.isNull(parentReply.getVestInteract()) || parentReply.getVestInteract() == 0) {
            this.adminNewsReplyMapper.updateVestInteractById(parentReply.getId(), parentReply.getNewsId());
            this.adminUserReplyMapper.updateVestInteractById(parentReply.getId(), parentReply.getUserId());
        }
        return adminNewsReply;
    }

    public CommentReplyConverter(AdminNewsReplyMapper adminNewsReplyMapper, AdminUserReplyMapper adminUserReplyMapper, VirtualUserIntegrationService virtualUserIntegrationService) {
        this.adminNewsReplyMapper = adminNewsReplyMapper;
        this.adminUserReplyMapper = adminUserReplyMapper;
        this.virtualUserIntegrationService = virtualUserIntegrationService;
    }
}

