/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.convert;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.VirtualUserIntegrationService;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.enums.Converter;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.facade.service.ForumPostInnerService;
import com.bxm.localnews.news.model.param.NewsReplyAddParam;
import com.bxm.localnews.news.model.vo.NewsReply;
import com.bxm.localnews.news.util.HtmlContentUtil;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.filter.InputFilter;
import com.bxm.newidea.component.service.BaseService;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class NewsReplyConver
extends BaseService
implements Converter<NewsReplyAddParam, NewsReply> {
    private final UserIntegrationService userIntegrationService;
    private final UserProperties userProperties;
    private final NewsReplyMapper newsReplyMapper;
    private final VirtualUserIntegrationService virtualUserIntegrationService;
    private final ForumPostInnerService forumPostInnerService;

    public NewsReply convert(NewsReplyAddParam param) {
        NewsReply newsReply = new NewsReply();
        BeanUtils.copyProperties((Object)param, (Object)newsReply);
        if (StringUtils.isNotBlank((CharSequence)param.getReplyImg())) {
            newsReply.setStatus(Byte.valueOf(ReplyStatusEnum.WAIT_REVIEW.getCode()));
        } else {
            newsReply.setStatus(Byte.valueOf(ReplyStatusEnum.IS_SHOW.getCode()));
        }
        newsReply.setLikeCount(Integer.valueOf(0));
        newsReply.setRootId(Long.valueOf(0L));
        newsReply.setLevel(Byte.valueOf((byte)0));
        newsReply.setAddTime(new Date());
        newsReply.setInteractiveCount(Integer.valueOf(0));
        newsReply.setId(this.nextSequence());
        newsReply.setAreaCode(param.getAreaCode());
        if (null != param.getUserId()) {
            UserBean userBean = this.userIntegrationService.selectUserFromCache(param.getUserId());
            if (StringUtils.isBlank((CharSequence)userBean.getHeadImg()) || StringUtils.isBlank((CharSequence)userBean.getNickname())) {
                this.logger.info("\u8bc4\u8bba\u7528\u6237\u5934\u50cf\u6216\u6635\u79f0\u4e3a\u7a7a,userInfo={}", (Object)JSON.toJSONString((Object)userBean));
            }
            newsReply.setHeadImg(StringUtils.isBlank((CharSequence)userBean.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : userBean.getHeadImg());
            newsReply.setUserNickname(userBean.getNickname());
        }
        newsReply.setType(Byte.valueOf(ReplyTypeEnum.POST_REPLY.getCode()));
        boolean vestPost = false;
        if (newsReply.getParentId() == null || newsReply.getParentId() == 0L) {
            newsReply.setRootId(Long.valueOf(0L));
            newsReply.setParentId(Long.valueOf(0L));
            newsReply.setLevel(NewsConstant.REPLY_LEVEL_0);
            if (param.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
                UserBean postVoUser = this.userIntegrationService.selectUserFromCache(this.forumPostInnerService.getPostUserId(param.getNewsId()));
                vestPost = Objects.nonNull(postVoUser) && Objects.nonNull(postVoUser.getState()) && postVoUser.getState() == 3;
            }
        } else {
            NewsReply newsReplyDb = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getParentId(), param.getNewsId());
            if (newsReplyDb != null) {
                newsReply.setRootId(newsReplyDb.getRootId());
                Byte level = newsReplyDb.getLevel();
                if (level == 0) {
                    newsReply.setLevel(NewsConstant.REPLY_LEVEL_1);
                    newsReply.setRootId(newsReplyDb.getId());
                } else {
                    newsReply.setLevel(NewsConstant.REPLY_LEVEL_2);
                    newsReply.setRootId(newsReplyDb.getRootId());
                }
            }
        }
        if (Objects.nonNull(param.getParentUserId())) {
            UserBean parentUser = this.userIntegrationService.selectUserFromCache(param.getParentUserId());
            boolean bl = vestPost = vestPost || Objects.nonNull(parentUser) && Objects.nonNull(parentUser.getState()) && parentUser.getState() == 3;
        }
        if (vestPost) {
            newsReply.setVestInteract(Byte.valueOf((byte)0));
        }
        if (Objects.equals(this.virtualUserIntegrationService.exists(param.getUserId()), Boolean.TRUE)) {
            newsReply.setReplyUserType(Integer.valueOf(1));
        } else {
            Long parentUserId = Objects.isNull(param.getParentUserId()) ? this.forumPostInnerService.getPostUserId(param.getNewsId()) : param.getParentUserId();
            newsReply.setReplyUserType(Integer.valueOf(this.virtualUserIntegrationService.exists(parentUserId) != false ? 2 : 0));
        }
        newsReply.setReplyContent(InputFilter.builder((String)newsReply.getReplyContent()).filte());
        String contentWithHtml = this.replaceAtElement(newsReply.getReplyContent());
        newsReply.setReplyContentHtml(contentWithHtml);
        newsReply.setReplyContent(HtmlContentUtil.getForumPostTextFiled((String)("<p>" + contentWithHtml + "</p>")));
        return newsReply;
    }

    private String replaceAtElement(String content) {
        content = content.replace("\\u003c", "<");
        content = content.replace("\\u003e", ">");
        return content;
    }

    public NewsReplyConver(UserIntegrationService userIntegrationService, UserProperties userProperties, NewsReplyMapper newsReplyMapper, VirtualUserIntegrationService virtualUserIntegrationService, ForumPostInnerService forumPostInnerService) {
        this.userIntegrationService = userIntegrationService;
        this.userProperties = userProperties;
        this.newsReplyMapper = newsReplyMapper;
        this.virtualUserIntegrationService = virtualUserIntegrationService;
        this.forumPostInnerService = forumPostInnerService;
    }
}

