/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.param.UserWarmActionParam;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.PushMsgService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.UserWarmIntegrationService;
import com.bxm.localnews.integration.VirtualUserIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.GlobalConstant;
import com.bxm.localnews.news.constant.MemoryCacheKey;
import com.bxm.localnews.news.convert.CommentReplyConverter;
import com.bxm.localnews.news.domain.AdminAllReplyMapper;
import com.bxm.localnews.news.domain.AdminNewsReplyMapper;
import com.bxm.localnews.news.domain.AdminUserReplyMapper;
import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.event.ReplyAccessApplicationEvent;
import com.bxm.localnews.news.facade.service.ForumPostInnerService;
import com.bxm.localnews.news.facade.service.ForumPostTotalFacadeService;
import com.bxm.localnews.news.model.dto.AdminReplyDTOAdmin;
import com.bxm.localnews.news.model.dto.AdminReplyDetailDTO;
import com.bxm.localnews.news.model.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.news.model.entity.ForumPostTotalEntity;
import com.bxm.localnews.news.model.param.AdminAllReplyParam;
import com.bxm.localnews.news.model.param.AdminCommentReplyParam;
import com.bxm.localnews.news.model.param.AdminNewsReplyOriginalParam;
import com.bxm.localnews.news.model.param.AdminNewsReplyParam;
import com.bxm.localnews.news.model.param.ReplyStatusChangeParam;
import com.bxm.localnews.news.model.param.VirtualUserRandomQueryParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminNewsReply;
import com.bxm.localnews.news.model.vo.VirtualUser;
import com.bxm.localnews.news.service.AdminNewsReplyService;
import com.bxm.localnews.news.util.JudgeUtil;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.github.pagehelper.PageHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdminNewsReplyServiceImpl
implements AdminNewsReplyService {
    private static final Logger log = LoggerFactory.getLogger(AdminNewsReplyServiceImpl.class);
    private AdminNewsReplyMapper adminNewsReplyMapper;
    private AdminUserReplyMapper adminUserReplyMapper;
    private CommentReplyConverter commentReplyConverter;
    private LocationIntegrationService locationIntegrationService;
    private AdminAllReplyMapper adminAllReplyMapper;
    private VirtualUserIntegrationService virtualUserIntegrationService;
    private UserIntegrationService userIntegrationService;
    private CacheHolder cacheHolder;
    private PushMsgService pushMsgService;
    private ForumProperties forumProperties;
    private UserWarmIntegrationService userWarmIntegrationService;
    private ForumPostTotalFacadeService forumPostTotalFacadeService;
    private ForumPostInnerService forumPostInnerService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Json doGenerateReply(AdminNewsReplyOriginalParam adminNewsReplyOriginalParam) {
        long endTime;
        if (Objects.isNull(adminNewsReplyOriginalParam.getDeliveryType()) || adminNewsReplyOriginalParam.getDeliveryType() == 1 && StringUtils.isBlank((CharSequence)adminNewsReplyOriginalParam.getAreaCode())) {
            return ResultUtil.genFailedResult((String)"\u8bf7\u5148\u9009\u62e9\u533a\u57df\uff0c\u624d\u80fd\u9009\u62e9\u533a\u57df\u9a6c\u7532\u8fdb\u884c\u8bc4\u8bba");
        }
        Long newsId = adminNewsReplyOriginalParam.getNewsId();
        List userIdList = this.adminNewsReplyMapper.selectUserFromReply(newsId);
        List replyList = adminNewsReplyOriginalParam.getList();
        List<String> areaCode = Arrays.asList(adminNewsReplyOriginalParam.getAreaCode().split(","));
        log.info("\u9009\u62e9\u9a6c\u7532\u5e93\u7684\u533a\u57df\u4fe1\u606f: deliveryType: {}, areaCode:{}", (Object)adminNewsReplyOriginalParam.getDeliveryType(), areaCode);
        VirtualUserRandomQueryParam randomQueryParam = new VirtualUserRandomQueryParam();
        randomQueryParam.setNum(Integer.valueOf(replyList.size() + 10));
        randomQueryParam.setType(Byte.valueOf((byte)1));
        randomQueryParam.setExitUserId(userIdList);
        randomQueryParam.setDeliveryType(adminNewsReplyOriginalParam.getDeliveryType());
        randomQueryParam.setIncludeAreaCodes(areaCode);
        randomQueryParam.setSex(adminNewsReplyOriginalParam.getSex());
        List virtualUserList = this.virtualUserIntegrationService.getRandom(randomQueryParam);
        if (CollectionUtils.isEmpty((Collection)virtualUserList)) {
            return ResultUtil.genFailedResult((String)StringUtils.join((Object[])new String[]{"\u9009\u62e9\u7684\u533a\u57df: ", adminNewsReplyOriginalParam.getDeliveryType() == 0 ? GlobalConstant.GLOBAL_NAME : adminNewsReplyOriginalParam.getAreaCode(), " \u4e0b\u67e5\u627e\u4e0d\u5230\u53ef\u7528\u7684\u9a6c\u7532\u53f7\u8fdb\u884c\u8bc4\u8bba"}));
        }
        long startTime = adminNewsReplyOriginalParam.getStartTime().getTime();
        if (startTime > (endTime = adminNewsReplyOriginalParam.getEndTime().getTime())) {
            return ResultUtil.genFailedResult((String)"\u5f00\u59cb\u65f6\u95f4\u5728\u7ed3\u675f\u65f6\u95f4\u4e4b\u540e\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        int index = 0;
        int virtualUserCount = virtualUserList.size();
        for (AdminNewsReplyOriginalParam.Reply reply : replyList) {
            VirtualUserOverviewDTO queryVirtualUser;
            if (index > virtualUserCount - 1) {
                index = (int)(Math.random() * (double)virtualUserCount);
            }
            VirtualUser virtualUser = Objects.nonNull(reply.getVirtualUserId()) ? (null == (queryVirtualUser = this.virtualUserIntegrationService.getByIdCacheFirst(reply.getVirtualUserId())) ? (VirtualUser)virtualUserList.get(index) : this.convert(queryVirtualUser)) : (VirtualUser)virtualUserList.get(index);
            long indexTime = RandomUtils.nextLong((long)startTime, (long)endTime);
            AdminNewsReply adminNewsReply = new AdminNewsReply();
            adminNewsReply.setAddTime(new Date(indexTime));
            adminNewsReply.setDeleteFlag(Byte.valueOf((byte)0));
            adminNewsReply.setHeadImg(virtualUser.getHeadImg());
            adminNewsReply.setId(SequenceHolder.nextLongId());
            adminNewsReply.setLevel(Byte.valueOf((byte)0));
            adminNewsReply.setLikeCount(Integer.valueOf(0));
            adminNewsReply.setNewsId(adminNewsReplyOriginalParam.getNewsId());
            adminNewsReply.setReplyContent(reply.getContent());
            if (JudgeUtil.isPost((Long)newsId)) {
                adminNewsReply.setType(Byte.valueOf((byte)3));
            } else {
                adminNewsReply.setType(Byte.valueOf((byte)1));
            }
            adminNewsReply.setParentId(Long.valueOf(0L));
            adminNewsReply.setStatus(Byte.valueOf((byte)0));
            adminNewsReply.setUserId(virtualUser.getId());
            adminNewsReply.setUserNickname(virtualUser.getNickname());
            adminNewsReply.setInteractiveCount(Integer.valueOf(0));
            adminNewsReply.setRootId(Long.valueOf(0L));
            adminNewsReply.setAddAppUserId(adminNewsReplyOriginalParam.getAddAppUserId());
            adminNewsReply.setReplyUserType(Byte.valueOf((byte)1));
            this.adminNewsReplyMapper.insertSelective(adminNewsReply);
            this.adminUserReplyMapper.insertUserReplySelective(adminNewsReply);
            ++index;
        }
        long count = this.adminNewsReplyMapper.count(adminNewsReplyOriginalParam.getNewsId());
        log.info("\u865a\u62df\u8bc4\u8bba\u751f\u6210\uff0c\u5df2\u6709\u8bc4\u8bba\u6570:{},\u65b0\u95fb/\u5e16\u5b50id:{}", (Object)count, (Object)adminNewsReplyOriginalParam.getNewsId());
        if (JudgeUtil.isPost((Long)newsId)) {
            ForumPostTotalEntity totalEntity = ForumPostTotalEntity.builder().postId(adminNewsReplyOriginalParam.getNewsId()).commentCount(Long.valueOf(count)).build();
            this.forumPostTotalFacadeService.updateField(totalEntity);
        }
        this.removeReplyCache(adminNewsReplyOriginalParam.getNewsId());
        return ResultUtil.genSuccessMsg();
    }

    private void removeReplyCache(Long newsId) {
        if (null != newsId) {
            this.cacheHolder.sendEvictCmd(MemoryCacheKey.HOT_REPLY_CACHE, (Object[])new Long[]{newsId});
            this.cacheHolder.sendEvictCmd(MemoryCacheKey.REPLY_COUNT_CACHE, (Object[])new Long[]{newsId});
        }
    }

    private VirtualUser convert(VirtualUserOverviewDTO virtualUserOverviewDTO) {
        VirtualUser user = new VirtualUser();
        user.setId(virtualUserOverviewDTO.getId());
        user.setNickname(virtualUserOverviewDTO.getNickname());
        user.setHeadImg(virtualUserOverviewDTO.getHeadImg());
        return user;
    }

    @Override
    public PageWarper<AdminNewsReply> listNewsReply(AdminNewsReplyParam adminNewsReplyParam) {
        PageWarper newsReplyPageWarper = new PageWarper(this.adminNewsReplyMapper.queryByPageSize(adminNewsReplyParam));
        List adminNewsReplyList = newsReplyPageWarper.getList();
        if (CollectionUtils.isNotEmpty((Collection)adminNewsReplyList)) {
            adminNewsReplyList.parallelStream().forEach(e -> {
                e.setIsVirtualParentUser(Byte.valueOf((byte)(null != e.getParentUserId() && this.virtualUserIntegrationService.exists(e.getParentUserId()) != false ? 1 : 0)));
                e.setIsVirtualUser(Byte.valueOf((byte)(null != e.getUserId() && this.virtualUserIntegrationService.exists(e.getUserId()) != false ? 1 : 0)));
                UserBean replyUserInfo = this.userIntegrationService.selectUserFromCache(e.getUserId());
                Byte sex = replyUserInfo.getSex();
                if (Objects.isNull(sex)) {
                    e.setUserNickname(e.getUserNickname() + "(\u5973)");
                } else if (1 == sex) {
                    e.setUserNickname(e.getUserNickname() + "(\u7537)");
                } else if (2 == sex) {
                    e.setUserNickname(e.getUserNickname() + "(\u5973)");
                } else if (0 == sex) {
                    e.setUserNickname(e.getUserNickname() + "(\u672a\u77e5)");
                }
            });
        }
        return newsReplyPageWarper;
    }

    @Override
    public int doAddCommentReply(AdminCommentReplyParam adminCommentReplyParam) {
        AdminNewsReply adminNewsReply = this.commentReplyConverter.convert(adminCommentReplyParam);
        this.adminUserReplyMapper.insertUserReplySelective(adminNewsReply);
        int result = this.adminNewsReplyMapper.insertSelective(adminNewsReply);
        if (JudgeUtil.isPost((Long)adminNewsReply.getNewsId())) {
            this.removeReplyCache(adminNewsReply.getNewsId());
        }
        return result;
    }

    @Override
    public PageWarper<AdminReplyDTOAdmin> listAllNewsReply(AdminAllReplyParam adminAllReplyParam) {
        if (Objects.nonNull(adminAllReplyParam.getIsUserDelete()) && adminAllReplyParam.getIsUserDelete() == 2) {
            adminAllReplyParam.setIsUserDelete(null);
            adminAllReplyParam.setDeleteFlag(Byte.valueOf((byte)0));
        }
        if (Objects.nonNull(adminAllReplyParam.getCommentStatus())) {
            if (Objects.equals(adminAllReplyParam.getCommentStatus(), ReplyStatusEnum.USER_DELETE.getCode())) {
                adminAllReplyParam.setCommentStatus(null);
                adminAllReplyParam.setDeleteFlag(Byte.valueOf((byte)1));
                adminAllReplyParam.setIsUserDelete(Byte.valueOf((byte)1));
            } else if (Objects.equals(adminAllReplyParam.getCommentStatus(), ReplyStatusEnum.MANAGE_DELETE.getCode())) {
                adminAllReplyParam.setCommentStatus(null);
                adminAllReplyParam.setIsUserDelete(Byte.valueOf((byte)0));
                adminAllReplyParam.setDeleteFlag(Byte.valueOf((byte)1));
            } else {
                adminAllReplyParam.setDeleteFlag(Byte.valueOf((byte)0));
            }
        }
        PageHelper.startPage((int)adminAllReplyParam.getPageNum(), (int)adminAllReplyParam.getPageSize());
        PageWarper adminReplyDTOAdminPageWarper = new PageWarper(this.adminAllReplyMapper.listAllNewsReply(adminAllReplyParam));
        List postIdList = adminReplyDTOAdminPageWarper.getList().stream().map(AdminNewsReply::getNewsId).collect(Collectors.toList());
        Map postRelationMap = this.forumPostInnerService.queryPostRelation(postIdList);
        adminReplyDTOAdminPageWarper.getList().forEach(replyInfo -> {
            if (StringUtils.isNotEmpty((CharSequence)replyInfo.getAreaCode())) {
                List areaCodeList = (List)postRelationMap.get(replyInfo.getNewsId());
                replyInfo.setAreaDetail(this.locationIntegrationService.batchGetDetailJson(areaCodeList));
            }
            replyInfo.setLinkUrl(ProtocolFactory.forumPost().outer().noExtend().userId(replyInfo.getUserId()).postId(replyInfo.getNewsId()).debug().build());
            replyInfo.setIsVirtualParentUser(Byte.valueOf((byte)(null != replyInfo.getParentUserId() && this.virtualUserIntegrationService.exists(replyInfo.getParentUserId()) != false ? 1 : 0)));
            replyInfo.setIsVirtualUser(Byte.valueOf((byte)(null != replyInfo.getUserId() && this.virtualUserIntegrationService.exists(replyInfo.getUserId()) != false ? 1 : 0)));
            replyInfo.setCommentStatus(replyInfo.getStatus());
            if (Objects.nonNull(replyInfo.getDeleteFlag()) && replyInfo.getDeleteFlag().intValue() == 1) {
                replyInfo.setCommentStatus(Byte.valueOf(Objects.equals(replyInfo.getIsUserDelete(), (byte)1) ? ReplyStatusEnum.USER_DELETE.getCode() : ReplyStatusEnum.MANAGE_DELETE.getCode()));
            }
        });
        return adminReplyDTOAdminPageWarper;
    }

    @Override
    public Message statusChange(ReplyStatusChangeParam param) {
        AdminNewsReply adminNewsReply = this.adminNewsReplyMapper.selectByPrimaryKey(param.getReplyId(), param.getNewsId());
        if (Objects.isNull(adminNewsReply)) {
            return Message.build((boolean)false, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ReplyStatusEnum statusEnum = null;
        if (Objects.equals(param.getOptionType(), (byte)1)) {
            statusEnum = ReplyStatusEnum.IS_SHOW;
            this.handleWarmMedalCounterData(param.getCurrentUserId());
        } else if (Objects.equals(param.getOptionType(), (byte)2)) {
            statusEnum = ReplyStatusEnum.REFUSE;
        } else if (Objects.equals(param.getOptionType(), (byte)3)) {
            statusEnum = ReplyStatusEnum.SELF;
        } else {
            return Message.build((boolean)false, (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
        }
        this.adminNewsReplyMapper.updateStatus(param.getReplyId(), param.getNewsId(), statusEnum.getCode());
        if (Objects.equals(statusEnum, ReplyStatusEnum.REFUSE)) {
            this.pushMsgService.pushReplyDeleteAndRejectMsg(adminNewsReply.getReplyContent(), adminNewsReply.getUserId(), this.forumProperties.getOfficialRulePostId());
        } else if (Objects.equals(statusEnum, ReplyStatusEnum.IS_SHOW) && Objects.equals(adminNewsReply.getStatus(), ReplyStatusEnum.WAIT_REVIEW.getCode())) {
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new ReplyAccessApplicationEvent(adminNewsReply.getId(), adminNewsReply.getNewsId()));
        }
        this.cacheHolder.sendEvictCmd(MemoryCacheKey.REPLY_COUNT_CACHE, (Object[])new Long[]{param.getNewsId()});
        return Message.build();
    }

    @Override
    public AdminReplyDetailDTO getReplyDetail(Long newsId, Long replyId) {
        AdminNewsReply adminNewsReply = this.adminNewsReplyMapper.selectByPrimaryKey(replyId, newsId);
        if (adminNewsReply.getRootId() != 0L) {
            adminNewsReply = this.adminNewsReplyMapper.selectByPrimaryKey(adminNewsReply.getRootId(), newsId);
        }
        adminNewsReply.setIsVirtualParentUser(Byte.valueOf((byte)(null != adminNewsReply.getParentUserId() && this.virtualUserIntegrationService.exists(adminNewsReply.getParentUserId()) != false ? 1 : 0)));
        adminNewsReply.setIsVirtualUser(Byte.valueOf((byte)(null != adminNewsReply.getUserId() && this.virtualUserIntegrationService.exists(adminNewsReply.getUserId()) != false ? 1 : 0)));
        AdminReplyDetailDTO replyDetailDTO = new AdminReplyDetailDTO();
        BeanUtils.copyProperties((Object)adminNewsReply, (Object)replyDetailDTO);
        List childs = this.adminNewsReplyMapper.selectByRootId(adminNewsReply.getId(), adminNewsReply.getNewsId());
        childs.forEach(e -> {
            e.setIsVirtualParentUser(Byte.valueOf((byte)(null != e.getParentUserId() && this.virtualUserIntegrationService.exists(e.getParentUserId()) != false ? 1 : 0)));
            e.setIsVirtualUser(Byte.valueOf((byte)(null != e.getUserId() && this.virtualUserIntegrationService.exists(e.getUserId()) != false ? 1 : 0)));
        });
        replyDetailDTO.setList(childs);
        Byte type = adminNewsReply.getType();
        if (type == 3) {
            AdminForumPost adminForumPost = this.forumPostInnerService.getAdminForumPost(adminNewsReply.getNewsId());
            adminForumPost.setLinkUrl(ProtocolFactory.forumPost().outer().postId(adminForumPost.getId()).userId(adminForumPost.getUserId()).build());
            replyDetailDTO.setForumPost(adminForumPost);
        }
        return replyDetailDTO;
    }

    private void handleWarmMedalCounterData(Long currentUserId) {
        UserWarmActionParam userWarmActionParam = UserWarmActionParam.builder().userId(currentUserId).warmRuleEnum(WarmRuleEnum.COMMENT).build();
        this.userWarmIntegrationService.updateWarm(userWarmActionParam);
    }

    public AdminNewsReplyServiceImpl(AdminNewsReplyMapper adminNewsReplyMapper, AdminUserReplyMapper adminUserReplyMapper, CommentReplyConverter commentReplyConverter, LocationIntegrationService locationIntegrationService, AdminAllReplyMapper adminAllReplyMapper, VirtualUserIntegrationService virtualUserIntegrationService, UserIntegrationService userIntegrationService, CacheHolder cacheHolder, PushMsgService pushMsgService, ForumProperties forumProperties, UserWarmIntegrationService userWarmIntegrationService, ForumPostTotalFacadeService forumPostTotalFacadeService, ForumPostInnerService forumPostInnerService) {
        this.adminNewsReplyMapper = adminNewsReplyMapper;
        this.adminUserReplyMapper = adminUserReplyMapper;
        this.commentReplyConverter = commentReplyConverter;
        this.locationIntegrationService = locationIntegrationService;
        this.adminAllReplyMapper = adminAllReplyMapper;
        this.virtualUserIntegrationService = virtualUserIntegrationService;
        this.userIntegrationService = userIntegrationService;
        this.cacheHolder = cacheHolder;
        this.pushMsgService = pushMsgService;
        this.forumProperties = forumProperties;
        this.userWarmIntegrationService = userWarmIntegrationService;
        this.forumPostTotalFacadeService = forumPostTotalFacadeService;
        this.forumPostInnerService = forumPostInnerService;
    }
}

