/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.domain.AdminReplyLibraryMapper;
import com.bxm.localnews.news.model.param.AdminNewsReplyOriginalParam;
import com.bxm.localnews.news.model.param.AdminReplyLibraryParam;
import com.bxm.localnews.news.model.param.AdminReplyOriginalParam;
import com.bxm.localnews.news.model.param.ReplyCategoryParam;
import com.bxm.localnews.news.model.vo.AdminReplyLibrary;
import com.bxm.localnews.news.model.vo.AdminReplyLibraryCategory;
import com.bxm.localnews.news.service.AdminNewsReplyService;
import com.bxm.localnews.news.service.AdminReplyLibraryService;
import com.bxm.localnews.news.vo.PageWarper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AdminReplyLibraryServiceImpl
implements AdminReplyLibraryService {
    @Resource
    private AdminReplyLibraryMapper adminReplyLibraryMapper;
    @Resource
    private AdminNewsReplyService adminNewsReplyService;

    @Override
    public PageWarper<AdminReplyLibrary> getList(AdminReplyLibraryParam param) {
        return new PageWarper(this.adminReplyLibraryMapper.getList(param));
    }

    @Override
    public AdminReplyLibrary selectByPrimaryKey(Long id) {
        return this.adminReplyLibraryMapper.selectByPrimaryKey(id);
    }

    @Override
    public int batchInsert(List<AdminReplyLibrary> adminReplyLibraryList) {
        if (CollectionUtils.isEmpty(adminReplyLibraryList)) {
            return 0;
        }
        return this.adminReplyLibraryMapper.batchInsert(adminReplyLibraryList);
    }

    @Override
    public int updateByPrimaryKey(AdminReplyLibrary adminReplyLibrary) {
        return this.adminReplyLibraryMapper.updateByPrimaryKey(adminReplyLibrary);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.adminReplyLibraryMapper.deleteByPrimaryKey(id);
    }

    @Override
    public void generateVirtualReply(AdminReplyOriginalParam param) {
        if (null == param || CollectionUtils.isEmpty((Collection)param.getAdminReplyLibraryCategoryList())) {
            return;
        }
        ArrayList<AdminNewsReplyOriginalParam.Reply> replyList = new ArrayList<AdminNewsReplyOriginalParam.Reply>();
        for (AdminReplyLibraryCategory adminReplyLibraryCategory : param.getAdminReplyLibraryCategoryList()) {
            List replyStringList = this.adminReplyLibraryMapper.getRandList(adminReplyLibraryCategory.getId(), adminReplyLibraryCategory.getReplyCount());
            if (!CollectionUtils.isNotEmpty((Collection)replyStringList)) continue;
            for (String replyStr : replyStringList) {
                AdminNewsReplyOriginalParam.Reply reply = new AdminNewsReplyOriginalParam.Reply();
                reply.setContent(replyStr);
                replyList.add(reply);
            }
        }
        AdminNewsReplyOriginalParam replyParam = new AdminNewsReplyOriginalParam();
        replyParam.setNewsId(param.getNewsId());
        replyParam.setStartTime(param.getStartTime());
        replyParam.setEndTime(param.getEndTime());
        replyParam.setList(replyList);
        this.adminNewsReplyService.doGenerateReply(replyParam);
    }

    @Override
    public List<AdminReplyLibrary> getReplyByCategoryId(ReplyCategoryParam param) {
        return this.adminReplyLibraryMapper.getRandListByCategoryId(param);
    }
}

