/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.VirtualUserIntegrationService;
import com.bxm.localnews.news.comment.service.CommentFacadeService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.config.ReplyConfigProperties;
import com.bxm.localnews.news.constant.MemoryCacheKey;
import com.bxm.localnews.news.domain.AllReplyMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.facade.service.ForumPostInnerService;
import com.bxm.localnews.news.model.dto.NewsReplyDTO;
import com.bxm.localnews.news.model.dto.NewsReplyMirrorDTO;
import com.bxm.localnews.news.model.entity.NewsReplyAllCountInfo;
import com.bxm.localnews.news.model.param.NewsReplyParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.NewsReply;
import com.bxm.localnews.news.model.vo.UserReply;
import com.bxm.localnews.news.model.vo.VirtualUser;
import com.bxm.localnews.news.util.JudgeUtil;
import com.bxm.localnews.news.utils.CommentUtil;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.tools.DateBeautifyUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommentFacadeServiceImpl
implements CommentFacadeService {
    private static final Logger log = LoggerFactory.getLogger(CommentFacadeServiceImpl.class);
    private NewsReplyMapper newsReplyMapper;
    private ForumProperties forumProperties;
    private ForumPostInnerService forumPostInnerService;
    private CacheHolder cacheHolder;
    private AllReplyMapper allReplyMapper;
    private UserReplyMapper userReplyMapper;
    private ReplyConfigProperties replyConfigProperties;
    private VirtualUserIntegrationService virtualUserIntegrationService;

    public Integer replyNum(Long newsId, Long userId, String areaCode) {
        List allReplayList = (List)this.cacheHolder.get(MemoryCacheKey.REPLY_COUNT_CACHE, (Object)newsId);
        if (CollectionUtils.isEmpty((Collection)allReplayList)) {
            return 0;
        }
        allReplayList = CommentUtil.filter(allReplayList, userId, areaCode);
        return allReplayList.size();
    }

    @PostConstruct
    private void initCache() {
        SyncCacheHolderFactory.builder().keyGenerator(MemoryCacheKey.HOT_REPLY_CACHE).duration(5L).timeUnit(TimeUnit.MINUTES).cacheLoader(this::queryHotReplyWithPostId).build();
        SyncCacheHolderFactory.builder().keyGenerator(MemoryCacheKey.REPLY_COUNT_CACHE).duration(60L).timeUnit(TimeUnit.SECONDS).cacheLoader(arg_0 -> ((NewsReplyMapper)this.newsReplyMapper).queryTotalReplay(arg_0)).build();
    }

    private List<NewsReplyDTO> queryHotReplyWithPostId(Long postId) {
        NewsReplyParam param = new NewsReplyParam();
        param.setNewsId(Long.valueOf(postId));
        return this.getHotReplayWithLimit(param, 10);
    }

    public List<NewsReplyDTO> getCacheHotReply(Long postId, Long userId, String areaCode) {
        List result = (List)this.cacheHolder.get(MemoryCacheKey.HOT_REPLY_CACHE, (Object)postId);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            result = result.stream().map(reply -> {
                NewsReplyDTO res = new NewsReplyDTO();
                BeanUtils.copyProperties((Object)reply, (Object)res);
                return res;
            }).collect(Collectors.toList());
        }
        if ((result = CommentUtil.filter(result, userId, areaCode)).size() > 0) {
            NewsReplyDTO hotReply = (NewsReplyDTO)result.get(0);
            hotReply.setList(null);
            return Collections.singletonList(hotReply);
        }
        return Lists.newArrayList();
    }

    private List<NewsReplyDTO> getHotReplayWithLimit(NewsReplyParam newsReplyParam, int limit) {
        List allReplyList = this.newsReplyMapper.queryAllReplyWithContent(newsReplyParam.getNewsId(), newsReplyParam.getUserId());
        return this.execReplyLogic(allReplyList, newsReplyParam, false).stream().filter(reply -> Objects.equals(reply.getHotReply(), 1)).limit(limit).collect(Collectors.toList());
    }

    public List<NewsReplyDTO> getHotReplays(NewsReplyParam newsReplyParam) {
        List result = (List)this.cacheHolder.get(MemoryCacheKey.HOT_REPLY_CACHE, (Object)newsReplyParam.getNewsId());
        return result.stream().limit(this.forumProperties.getHotReplyViewNum().intValue()).map(reply -> {
            NewsReplyDTO res = new NewsReplyDTO();
            BeanUtils.copyProperties((Object)reply, (Object)res);
            return res;
        }).collect(Collectors.toList());
    }

    public List<NewsReplyAllCountInfo> getAuditReplyCount(Date startTime, Date endTime) {
        return this.allReplyMapper.countAuditReply(startTime, endTime);
    }

    public List<NewsReplyDTO> execReplyLogic(List<NewsReplyDTO> allReplyList, NewsReplyParam newsReplyParam, boolean isHotReplies) {
        if ((allReplyList = CommentUtil.filter(allReplyList, newsReplyParam.getUserId(), newsReplyParam.getAreaCode())).size() == 0) {
            return allReplyList;
        }
        List replyLikesTemp = Collections.emptyList();
        Long authorId = 0L;
        if (Objects.nonNull(newsReplyParam.getUserId())) {
            if (JudgeUtil.isPost((Long)newsReplyParam.getNewsId())) {
                authorId = this.forumPostInnerService.getPostUserId(newsReplyParam.getNewsId());
            }
            replyLikesTemp = this.newsReplyMapper.selectReplyLike(newsReplyParam.getNewsId(), newsReplyParam.getUserId(), null);
        }
        List replyLikes = replyLikesTemp;
        Long finalAuthorId = authorId;
        allReplyList.forEach(reply -> {
            reply.setUserIsAuthor(Boolean.valueOf(Objects.equals(reply.getUserId(), finalAuthorId)));
            reply.setParentUserIsAuthor(Boolean.valueOf(Objects.equals(reply.getParentUserId(), finalAuthorId)));
            if (Objects.equals(reply.getDeleteFlag(), 2)) {
                reply.setDeleteFlag(Byte.valueOf((byte)1));
                reply.setReplyContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664!");
            }
            reply.setReplyTime(DateBeautifyUtils.timeConvertString((Date)reply.getAddTime()));
            reply.setIsLike(Integer.valueOf(this.checkIsLike(replyLikes, reply.getId())));
        });
        if (isHotReplies) {
            allReplyList.forEach(reply -> {
                if (!CollectionUtils.isEmpty((Collection)reply.getList())) {
                    reply.getList().forEach(sub -> this.dealSubMirrorDTO((NewsReplyMirrorDTO)sub, newsReplyParam.getUserId(), replyLikes));
                }
            });
            return allReplyList;
        }
        List<NewsReplyDTO> parentReplyList = allReplyList.stream().filter(reply -> Objects.equals(reply.getParentId(), 0L)).collect(Collectors.toList());
        for (NewsReplyDTO parentReply : parentReplyList) {
            List<NewsReplyMirrorDTO> subReplyList = allReplyList.stream().filter(reply -> Objects.equals(reply.getRootId(), parentReply.getId())).sorted(Comparator.comparing(NewsReplyDTO::getAddTime)).map(reply -> {
                NewsReplyMirrorDTO mirrorDTO = new NewsReplyMirrorDTO();
                BeanUtils.copyProperties((Object)reply, (Object)mirrorDTO);
                return mirrorDTO;
            }).collect(Collectors.toList());
            subReplyList.forEach(subReply -> this.dealSubMirrorDTO((NewsReplyMirrorDTO)subReply, newsReplyParam.getUserId(), replyLikes));
            parentReply.setList(subReplyList);
        }
        return parentReplyList;
    }

    private int checkIsLike(List<Long> replyLikes, Long replyId) {
        return replyLikes.contains(replyId) ? 1 : 0;
    }

    public void dealSubMirrorDTO(NewsReplyMirrorDTO replay, Long userId, List<Long> replyLikes) {
        replay.setIsLike(Integer.valueOf(this.checkIsLike(replyLikes, replay.getId())));
        if (replay.getLevel().equals(NewsConstant.REPLY_LEVEL_1)) {
            replay.setParentHeadImg(null);
            replay.setParentUserId(null);
            replay.setParentUserNickname(null);
        }
        replay.setReplyTime(DateBeautifyUtils.timeConvertString((Date)replay.getAddTime()));
    }

    @Async
    public void addPostReply(ForumPostVo forumPostVo) {
        try {
            List list = this.newsReplyMapper.selectRandomReplyLibrary(this.replyConfigProperties.getNewReportId(), 24);
            List userList = this.virtualUserIntegrationService.getRandom(Integer.valueOf(24));
            int choiceNum = ThreadLocalRandom.current().nextInt(3, 6);
            this.addNewsReplyDo(forumPostVo, System.currentTimeMillis(), this.subList(list, 0, choiceNum), this.subList(userList, 0, choiceNum));
            choiceNum = ThreadLocalRandom.current().nextInt(3, 6);
            this.addNewsReplyDo(forumPostVo, System.currentTimeMillis() + 86400000L, this.subList(list, 5, choiceNum), this.subList(userList, 5, choiceNum));
            choiceNum = ThreadLocalRandom.current().nextInt(1, 2);
            this.addNewsReplyDo(forumPostVo, System.currentTimeMillis() + 172800000L, this.subList(list, 10, choiceNum), this.subList(userList, 10, choiceNum));
        }
        catch (Exception e) {
            log.error("\u589e\u52a0\u8bc4\u8bba\u5931\u8d25, forumPostVo: {}", (Object)JSON.toJSONString((Object)forumPostVo), (Object)e);
        }
    }

    private <T> List<T> subList(List<T> list, int start, int limit) {
        return list.stream().skip(start).limit(limit).collect(Collectors.toList());
    }

    private void addNewsReplyDo(ForumPostVo forumPostVo, long currentTime, List<String> list, List<VirtualUser> userList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list) || org.apache.commons.collections.CollectionUtils.isEmpty(userList)) {
            return;
        }
        int i = 0;
        for (String replyContent : list) {
            int nextTime = ThreadLocalRandom.current().nextInt(120000);
            VirtualUser virtualUser = userList.get(i);
            NewsReply newsReply = new NewsReply();
            newsReply.setAddTime(new Date(currentTime + (long)nextTime));
            newsReply.setDeleteFlag((byte)0);
            newsReply.setHeadImg(virtualUser.getHeadImg());
            newsReply.setId(SequenceHolder.nextLongId());
            newsReply.setLevel(Byte.valueOf((byte)0));
            newsReply.setLikeCount(Integer.valueOf(0));
            newsReply.setNewsId(forumPostVo.getId());
            newsReply.setReplyContent(replyContent);
            newsReply.setType(Byte.valueOf((byte)3));
            newsReply.setParentId(Long.valueOf(0L));
            newsReply.setStatus(Byte.valueOf((byte)0));
            newsReply.setUserId(virtualUser.getId());
            newsReply.setUserNickname(virtualUser.getNickname());
            newsReply.setInteractiveCount(Integer.valueOf(0));
            newsReply.setRootId(Long.valueOf(0L));
            newsReply.setReplyUserType(Integer.valueOf(1));
            this.newsReplyMapper.insertSelective(newsReply);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)newsReply, (Object)userReply);
            this.userReplyMapper.insertSelective(userReply);
            ++i;
        }
    }

    public CommentFacadeServiceImpl(NewsReplyMapper newsReplyMapper, ForumProperties forumProperties, ForumPostInnerService forumPostInnerService, CacheHolder cacheHolder, AllReplyMapper allReplyMapper, UserReplyMapper userReplyMapper, ReplyConfigProperties replyConfigProperties, VirtualUserIntegrationService virtualUserIntegrationService) {
        this.newsReplyMapper = newsReplyMapper;
        this.forumProperties = forumProperties;
        this.forumPostInnerService = forumPostInnerService;
        this.cacheHolder = cacheHolder;
        this.allReplyMapper = allReplyMapper;
        this.userReplyMapper = userReplyMapper;
        this.replyConfigProperties = replyConfigProperties;
        this.virtualUserIntegrationService = virtualUserIntegrationService;
    }
}

