/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.param.UserWarmActionParam;
import com.bxm.localnews.integration.MessageService;
import com.bxm.localnews.integration.UserWarmIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.MemoryCacheKey;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.model.dto.NewsReplyDTO;
import com.bxm.localnews.news.model.param.ReplyOperateParam;
import com.bxm.localnews.news.model.vo.NewsReply;
import com.bxm.localnews.news.model.vo.ReplyOperate;
import com.bxm.localnews.news.service.HotReplayService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.sync.core.CacheHolder;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HotReplayServiceImpl
implements HotReplayService {
    private static final Logger log = LoggerFactory.getLogger(HotReplayServiceImpl.class);
    private NewsReplyMapper newsReplyMapper;
    private ForumProperties forumProperties;
    private MessageService messageService;
    private DistributedLock distributedLock;
    private CacheHolder cacheHolder;
    private UserWarmIntegrationService userWarmIntegrationService;
    private static final int PAGE_NUM = 50;

    @Override
    public void calHotReplay() {
        for (long index = 0L; index < 10L; ++index) {
            this.queryHotReplayIterator(index, 0);
        }
    }

    private void queryHotReplayIterator(Long index, int page) {
        List hotReplayList = this.newsReplyMapper.getNoHotReplayByLikeCount(index, this.forumProperties.getHotReplyForLikeCountNum().intValue(), page * 50, 50);
        if (hotReplayList.size() > 0) {
            this.setHotReplay(hotReplayList);
            if (hotReplayList.size() == 50) {
                this.queryHotReplayIterator(index, page + 1);
            }
        }
    }

    private void setHotReplay(List<NewsReplyDTO> hotReplayList) {
        for (NewsReplyDTO newsReplyDTO : hotReplayList) {
            this.operateReply(ReplyOperateParam.builder().replyId(newsReplyDTO.getId()).newsId(newsReplyDTO.getNewsId()).operate(Integer.valueOf(2)).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean operateReply(ReplyOperateParam param) {
        NewsReply newsReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(param.getReplyId(), param.getNewsId());
        if (Objects.nonNull(newsReply) && !Objects.equals(newsReply.getStatus(), ReplyStatusEnum.IS_SHOW.getCode())) {
            log.warn("\u5e16\u5b50: {} \u8bc4\u8bba: {}\u7684\u72b6\u6001\u4e0d\u5728\u5c55\u793a\u72b6\u6001 \u4e0d\u80fd\u505a\u5904\u7406", (Object)param.getNewsId(), (Object)param.getReplyId());
            return false;
        }
        ReplyOperate replyOperate = new ReplyOperate();
        replyOperate.setReplyId(param.getReplyId());
        replyOperate.setNewsId(param.getNewsId());
        switch (param.getOperate()) {
            case 1: {
                replyOperate.setDisplayOwner(Integer.valueOf(1));
                replyOperate.setStatus(Byte.valueOf(ReplyStatusEnum.SELF.getCode()));
                this.messageService.sendMessageFilterForReply(param.getUserId(), param.getReplyId());
                break;
            }
            case 2: {
                replyOperate.setHotReply(Integer.valueOf(1));
                replyOperate.setHotReplyTime(new Date());
                break;
            }
            case 3: {
                replyOperate.setHotReply(Integer.valueOf(0));
                replyOperate.setHotReplyTime(new Date());
                break;
            }
        }
        KeyGenerator lockKey = RedisConfig.REPLY_UPDATE_OWNER_HOT.copy().appendKey((Object)param.getUserId()).appendKey((Object)param.getReplyId());
        if (this.distributedLock.lock(lockKey.gen())) {
            try {
                this.newsReplyMapper.updateDisplayOwnerAndHotReply(replyOperate);
                this.handOutWarm(replyOperate.getHotReply(), param.getReplyId());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.distributedLock.unlock(lockKey.gen());
            }
        }
        this.cacheHolder.sendEvictCmd(MemoryCacheKey.HOT_REPLY_CACHE, (Object[])new Long[]{param.getNewsId()});
        this.cacheHolder.sendEvictCmd(MemoryCacheKey.REPLY_COUNT_CACHE, (Object[])new Long[]{param.getNewsId()});
        return Boolean.TRUE;
    }

    private void handOutWarm(Integer hotReply, Long replyId) {
        NewsReply newsReply;
        if (Objects.nonNull(hotReply) && Objects.nonNull(newsReply = this.newsReplyMapper.selectByPrimaryKey(replyId)) && Objects.nonNull(newsReply.getUserId())) {
            this.userWarmIntegrationService.updateWarm(UserWarmActionParam.builder().userId(newsReply.getUserId()).warmRuleEnum(Objects.equals(hotReply, 1) ? WarmRuleEnum.COMMENT_UP_HOT : WarmRuleEnum.CANCEL_COMMENT_HOT).build());
        }
    }

    public HotReplayServiceImpl(NewsReplyMapper newsReplyMapper, ForumProperties forumProperties, MessageService messageService, DistributedLock distributedLock, CacheHolder cacheHolder, UserWarmIntegrationService userWarmIntegrationService) {
        this.newsReplyMapper = newsReplyMapper;
        this.forumProperties = forumProperties;
        this.messageService = messageService;
        this.distributedLock = distributedLock;
        this.cacheHolder = cacheHolder;
        this.userWarmIntegrationService = userWarmIntegrationService;
    }
}

