/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.VirtualUserIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.GlobalConstant;
import com.bxm.localnews.news.domain.AdminAllReplyMapper;
import com.bxm.localnews.news.facade.service.ForumPostInnerService;
import com.bxm.localnews.news.model.dto.VirtualReplyDTO;
import com.bxm.localnews.news.model.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.news.model.entity.VirtualReply;
import com.bxm.localnews.news.model.param.VirtualReplyListParam;
import com.bxm.localnews.news.service.VirtualReplyService;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.tools.DateUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VirtualReplyServiceImpl
implements VirtualReplyService {
    private static final Logger log = LoggerFactory.getLogger(VirtualReplyServiceImpl.class);
    private final AdminAllReplyMapper adminAllReplyMapper;
    private final ForumProperties forumProperties;
    private final VirtualUserIntegrationService virtualUserIntegrationService;
    private final LocationIntegrationService locationIntegrationService;
    private final ForumPostInnerService forumPostInnerService;

    @Override
    public PageWarper<VirtualReplyDTO> listByParam(VirtualReplyListParam param) {
        Date now = new Date();
        Date start = DateUtils.getClearDate((Date)DateUtils.addField((Date)now, (int)5, (int)(this.forumProperties.getMaxReplyQueryDay() * -1)));
        if (Objects.isNull(param.getStartTime())) {
            param.setStartTime(start);
        } else if (param.getStartTime().before(start)) {
            param.setStartTime(start);
        }
        if (Objects.isNull(param.getEndTime())) {
            param.setEndTime(now);
        }
        Page page = PageMethod.startPage((Object)param).doSelectPage(() -> this.adminAllReplyMapper.listVirtualReply(param));
        List postIdList = page.getResult().stream().map(VirtualReply::getNewsId).collect(Collectors.toList());
        Map postRelationMap = this.forumPostInnerService.queryPostRelation(postIdList);
        PageWarper result = new PageWarper((List)page);
        result.setList(page.getResult().stream().map(replay -> this.convert((VirtualReply)replay, postRelationMap)).collect(Collectors.toList()));
        return result;
    }

    private VirtualReplyDTO convert(VirtualReply reply, Map<Long, List<String>> postRelationMap) {
        VirtualReplyDTO replyDTO = new VirtualReplyDTO();
        replyDTO.setId(reply.getId());
        replyDTO.setNewsId(reply.getNewsId());
        if (StringUtils.isBlank((CharSequence)reply.getTitle())) {
            replyDTO.setNewsTitle(reply.getTextField());
        } else {
            replyDTO.setNewsTitle(reply.getTitle());
        }
        if (Objects.nonNull(reply.getLevel()) && reply.getLevel().intValue() == 0) {
            replyDTO.setVirtualNickName(reply.getPostUserNickName());
            replyDTO.setVirtualUserId(reply.getPostUserId());
        } else {
            replyDTO.setVirtualNickName(reply.getParentUserNickname());
            replyDTO.setVirtualUserId(reply.getParentUserId());
        }
        replyDTO.setUserNickName(reply.getUserNickname());
        replyDTO.setUserId(reply.getUserId());
        replyDTO.setReplyStatus(Integer.valueOf(Objects.isNull(reply.getVestInteract()) ? 0 : reply.getVestInteract().intValue()));
        replyDTO.setReplyContent(reply.getReplyContent());
        replyDTO.setReplyTime(DateUtils.formatDateTime((Date)reply.getAddTime()));
        VirtualUserOverviewDTO virtualUserOverviewDTO = this.virtualUserIntegrationService.getByIdCacheFirst(replyDTO.getVirtualUserId());
        if (Objects.nonNull(virtualUserOverviewDTO) && StringUtils.isNotBlank((CharSequence)virtualUserOverviewDTO.getAreaCode()) && !Objects.equals(virtualUserOverviewDTO.getAreaCode(), GlobalConstant.GLOBAL_AREA)) {
            replyDTO.setVirtualAreaNames(this.locationIntegrationService.batchGetDetailJson(postRelationMap.get(reply.getNewsId())));
        } else {
            replyDTO.setVirtualAreaNames(GlobalConstant.GLOBAL_NAME);
        }
        return replyDTO;
    }

    public VirtualReplyServiceImpl(AdminAllReplyMapper adminAllReplyMapper, ForumProperties forumProperties, VirtualUserIntegrationService virtualUserIntegrationService, LocationIntegrationService locationIntegrationService, ForumPostInnerService forumPostInnerService) {
        this.adminAllReplyMapper = adminAllReplyMapper;
        this.forumProperties = forumProperties;
        this.virtualUserIntegrationService = virtualUserIntegrationService;
        this.locationIntegrationService = locationIntegrationService;
        this.forumPostInnerService = forumPostInnerService;
    }
}

