/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.utils;

import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.model.vo.NewsReplyBaseVO;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CommentUtil {
    private CommentUtil() {
    }

    public static <T extends NewsReplyBaseVO> List<T> filter(List<T> list, Long userId) {
        return list.stream().filter(replay -> replay.getDisplayOwner() == 0 || replay.getDisplayOwner() == 1 && Objects.equals(userId, replay.getUserId())).collect(Collectors.toList());
    }

    public static <T extends NewsReplyBaseVO> List<T> filter(List<T> allReplayList, Long userId, String areaCode) {
        if (null != userId) {
            allReplayList = allReplayList.stream().filter(reply -> {
                if (Objects.equals(reply.getDisplayOwner(), 0) && !Objects.equals(reply.getStatus(), ReplyStatusEnum.SELF.getCode())) {
                    return true;
                }
                return Objects.equals(reply.getDisplayOwner(), 1) && Objects.equals(userId, reply.getUserId()) || Objects.equals(reply.getStatus(), ReplyStatusEnum.SELF.getCode()) && Objects.equals(userId, reply.getUserId());
            }).collect(Collectors.toList());
        }
        if (areaCode != null) {
            allReplayList = allReplayList.stream().filter(reply -> {
                if (Objects.equals(reply.getReplyUserType(), 1)) {
                    return true;
                }
                return StringUtils.isBlank((CharSequence)reply.getAreaCode()) || StringUtils.equals((CharSequence)reply.getAreaCode(), (CharSequence)areaCode);
            }).collect(Collectors.toList());
        }
        List copyList = allReplayList;
        allReplayList = allReplayList.stream().filter(reply -> {
            if (Objects.equals(reply.getParentId(), 0L)) {
                return true;
            }
            return copyList.stream().anyMatch(parentReply -> Objects.equals(parentReply.getId(), reply.getParentId()));
        }).collect(Collectors.toList());
        return allReplayList;
    }
}

