/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.facade;

import com.bxm.localnews.news.create.PostCreateService;
import com.bxm.localnews.news.model.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.news.model.vo.RecommendUserFacadeVo;
import com.bxm.localnews.news.model.vo.topic.TopicFacadeVO;
import com.bxm.localnews.news.post.ForumPostFacadeService;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.service.ShareRankService;
import com.bxm.localnews.news.vo.UserImgVo;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-95 [\u5185\u90e8]\u5e16\u5b50\u63a5\u53e3"})
@RestController
@RequestMapping(value={"facade/forumPost"})
public class ForumPostFacadeController {
    private final ForumPostService forumPostService;
    private final ForumPostFacadeService forumPostFacadeService;
    private final ShareRankService shareRankService;
    private final PostCreateService postCreateService;

    @Autowired
    public ForumPostFacadeController(ForumPostService forumPostService, ForumPostFacadeService forumPostFacadeService, ShareRankService shareRankService, PostCreateService postCreateService) {
        this.forumPostService = forumPostService;
        this.forumPostFacadeService = forumPostFacadeService;
        this.shareRankService = shareRankService;
        this.postCreateService = postCreateService;
    }

    @ApiOperation(value="4-95-5 \u83b7\u53d6\u5e16\u5b50\u7b80\u7565\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postId", value="\u5e16\u5b50ID", required=true), @ApiImplicitParam(name="areaCode", value="\u8bbf\u95ee\u8bf7\u6c42\u6765\u6e90\u7528\u6237\u6240\u5c5e\u533a\u57df\u7f16\u7801"), @ApiImplicitParam(name="areaName", value="\u8bbf\u95ee\u8bf7\u6c42\u6765\u6e90\u7528\u6237\u6240\u5c5e\u533a\u57df\u540d\u79f0"), @ApiImplicitParam(name="userId", value="\u8bbf\u95ee\u63a5\u53e3\u7684\u7528\u6237ID")})
    @GetMapping(value={"briefInfo"})
    public ResponseEntity<ForumPostBriefInfoDto> getBriefInfo(@RequestParam(value="postId") Long postId, @RequestParam(value="areaCode", required=false) String areaCode, @RequestParam(value="areaName", required=false) String areaName, @RequestParam(value="userId", required=false) Long userId, HttpServletRequest request) {
        String ip = WebUtils.getIpAddr((HttpServletRequest)request);
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getBriefInfo(postId, userId, areaCode, ip));
    }

    @ApiOperation(value="4-95-9 \u6279\u91cf\u83b7\u53d6\u7528\u6237\u5e16\u5b50\u56fe\u7247", notes="\u672c\u5730\u4eba\u63a8\u8350\u5217\u8868\u4e2d\uff0c\u9700\u8981\u663e\u793a\u7528\u6237\u7684\u6700\u8fd1\u53d1\u5e16\u56fe\u7247\u5217\u8868\uff08\u6682\u4e0d\u5b9e\u73b0\uff09")
    @GetMapping(value={"batchGetUserImg"})
    public ResponseEntity<List<UserImgVo>> batchGetUserImg(@RequestParam(value="userIdList") List<Long> userIdList, @RequestParam(value="currentUserId", required=false) Long currentUserId) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.batchGetUserImg(userIdList, currentUserId));
    }

    @GetMapping(value={"getTopicById"})
    @ApiOperation(value="4-95-10 \u6839\u636eid\u83b7\u53d6\u8bdd\u9898\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8bdd\u9898ID", required=true)})
    public ResponseEntity<TopicFacadeVO> getTopicById(Long id) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getTopicById(id));
    }

    @ApiOperation(value="4-95-20 \u6839\u636e\u7528\u6237\u53d1\u5e16\u6570\u83b7\u53d6\u53d1\u5e16\u7528\u6237\u6392\u884c\uff08\u5e16\u5b50\u72b6\u6001\u4e3a\u901a\u8fc7\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7801"), @ApiImplicitParam(name="userIds", value="\u9700\u8981\u6392\u5e8f\u5df2\u5173\u6ce8\u8fc7\u7684\u7528\u6237")})
    @GetMapping(value={"getRecommendUserInfo"})
    public ResponseEntity<List<RecommendUserFacadeVo>> getRecommendUserInfo(@RequestParam(value="areaCode") String areaCode, @RequestParam(value="userIds") List<Long> userIds) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getRecommendUserInfo(areaCode, userIds));
    }

    @ApiOperation(value="4-95-21 \u6839\u636e\u5e16\u5b50id \u83b7\u53d6\u6240\u6709\u6d4f\u89c8\u8fc7\u5e16\u5b50\u7684\u7528\u6237id \uff08\u672a\u5206\u9875\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postId", value="\u5e16\u5b50id")})
    @GetMapping(value={"getViewedPostUserIds"})
    public ResponseEntity<List<Long>> getViewedPostUserIds(@RequestParam(value="postId") Long postId) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getViewedPostUserIds(postId));
    }
}

