package com.bxm.localnews.news.facade;

import com.bxm.localnews.news.facade.dto.ForumPostBriefInfoDTO;
import com.bxm.localnews.news.facade.dto.RecommendUserDTO;
import com.bxm.localnews.news.facade.dto.TopicFacadeDTO;
import com.bxm.localnews.news.facade.dto.UserImgDTO;
import com.bxm.localnews.news.facade.param.RecommendQueryParam;

import java.util.List;

/**
 * 帖子相关
 *
 * @author liujia
 * @date 9/29/21 4:45 PM
 **/
public interface ForumFacadeService {

    /**
     * 本地人推荐列表中，需要显示用户的最近发帖图片列表
     *
     * @param userIdList    用户ID列表
     * @param currentUserId 用户ID
     * @return 图片列表
     * @deprecated 不推荐调用
     */
    @Deprecated
    List<UserImgDTO> batchGetUserImg(List<Long> userIdList, Long currentUserId);

    /**
     * 根据用户发帖数获取发帖用户排行（帖子状态为通过）
     *
     * @param areaCode 地区编码
     * @param userId   当前用户ID，用于排除关注了的人
     * @return 推荐的用户列表
     * @deprecated 效率太低了，不要用了
     */
    @Deprecated
    List<RecommendUserDTO> getRecommendUserInfo(String areaCode, Long userId);

    /**
     * 分页获取推荐用户列表
     *
     * @param param
     * @return
     */
    List<RecommendUserDTO> getRecommendUserInfo(RecommendQueryParam param);

    /**
     * 获取话题信息
     *
     * @param topicId 话题ID
     * @return 话题详情
     */
    TopicFacadeDTO getTopicById(Long topicId);

    /**
     * 获取帖子简略信息
     *
     * @param postId 帖子ID
     * @return 帖子简略信息
     */
    ForumPostBriefInfoDTO getBriefInfo(Long postId);
}
