package com.bxm.localnews.news.facade;

/**
 * 用户信息同步接口
 *
 * @author liujia
 * @date 9/29/21 3:53 PM
 **/
public interface UserSyncFacadeService {

    /**
     * 变更用户定位
     */
    void changeLocation(Long userId, String areaCode);

    /**
     * 用户新增关注
     *
     * @param userId       用户
     * @param followUserId 关注的用户ID
     */
    void addFollow(Long userId, Long followUserId);

    /**
     * 移除关注状态
     *
     * @param userId         用户ID
     * @param unfollowUserId 解除关注的用户ID
     */
    void removeFollow(Long userId, Long unfollowUserId);
}
