package com.bxm.localnews.news.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel("我的收藏")
@Data
public class MyCollectDTO {

    @ApiModelProperty("帖子/新闻id")
    private Long id;

    @ApiModelProperty("帖子/新闻标题")
    private String title;

    @ApiModelProperty("图片数组")
    private List<String> imgList;

    @ApiModelProperty("收藏时间")
    private String collectTime;

    @ApiModelProperty("状态 0：失效 1：有效   如：状态为店铺时，有店铺下架的状态则为失效")
    private Integer status;

    @ApiModelProperty("类型 1:新闻 2:小视频 3:帖子 4:小纸条 5:店铺")
    private Byte type;

}
