package com.bxm.localnews.news.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author liujia
 * @date 2020-08-04 21:03
 **/
@Data
@ApiModel(description = "首页加号中的入口定义")
public class IndexPlusDTO {

    public static final int CURRENT_VERSION = 1;

    /**
     * 设置初始值，缓存回写时会被覆盖
     */
    @ApiModelProperty(value = "当前对象的版本", hidden = true)
    private Integer v = CURRENT_VERSION;

    @ApiModelProperty("发布页面的主要入口链接")
    private List<LinkDTO> primary;

    @ApiModelProperty("发布页面的次要入口链接")
    private List<LinkDTO> secondary;

    @ApiModelProperty("用户信息")
    private IndexPlusUserInfoDTO userInfo;

    @ApiModelProperty("引导文案 eg: 这是你加入蛋蛋佳的第1天...")
    private String guideContent;
}
