package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.param.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author gonzo
 * @date 2020-09-18 15:24
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "批量添加评论请求参数")
public class BatchAddReplyParam extends BasicParam {

    @ApiModelProperty(value = "用户id", required = true)
    @NotNull(message = "用户id不能为空")
    private Long userId;

    @ApiModelProperty(value = "帖子id", required = true)
    @NotNull(message = "帖子id不能为空")
    private Long forumId;

    @ApiModelProperty(value = "区域编码", required = true)
    @NotBlank(message = "区域编码不能为空")
    private String areaCode;

    @ApiModelProperty(value = "评论列表", required = true)
    @NotNull(message = "评论不能为空")
    private List<Reply> replyList;


    @Data
    @ApiModel(description = "评论参数")
    public static class Reply {

        @ApiModelProperty(value = "评论", required = true)
        private String content;
    }
}
