package com.bxm.localnews.news.domain;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.news.model.entity.ForumPostAreaRelationEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Mapper
public interface ForumPostAreaRelationMapper extends BaseMapper<ForumPostAreaRelationEntity> {

    /**
     * 查询帖子对应的投放启动
     *
     * @param postId 帖子ID
     * @return 投放关系映射表
     */
    List<ForumPostAreaRelationEntity> selectByPostId(Long postId);

    /**
     * 删除帖子的所有映射关系
     *
     * @param postId 帖子ID
     * @return 删除行数
     */
    int deleteByPostId(Long postId);
}
