package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.model.dto.ShareContentDTO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 帖子简历信息查询接口
 *
 * @author liujia
 * @date 2020/05/13 19:14
 */
@Mapper
public interface ForumPostBriefInfoMapper {

    /**
     * 查询地区靠前的阅读量最高的帖子
     *
     * @param displayTime 发布时间
     * @param areaCode    地区编码
     * @param limit       查询数量
     * @return 帖子简略信息
     */
    List<ShareContentDTO> getTopSharePostWithLimit(@Param("displayTime") Date displayTime,
                                                   @Param("areaCode") String areaCode,
                                                   @Param("limit") int limit);

    /**
     * 获取全国适用性的帖子用来防止非热门地区无帖子可分享的情况
     *
     * @param limit 查询数量
     * @return 帖子简略信息
     */
    List<ShareContentDTO> getGlobalPostWithLimit(@Param("limit") int limit);
}
