package com.bxm.localnews.news.domain;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.news.model.entity.ForumPostTotalEntity;
import com.bxm.localnews.news.model.vo.PostClickCountVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 帖子统计信息表 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Mapper
public interface ForumPostTotalMapper extends BaseMapper<ForumPostTotalEntity> {

    /**
     * 增加帖子的相关统计数据
     *
     * @param entity 统计实体信息
     * @return 统计结果
     */
    int addCount(ForumPostTotalEntity entity);

    /**
     * 统计话题下的参与人数
     *
     * @param topicId  帖子ID
     * @param areaCode 区域ID
     * @return 参与人数
     */
    Integer calcPostNum(@Param("topicId") Long topicId,
                        @Param("areaCode") String areaCode);

    /**
     * 获取用户的发帖数量
     *
     * @param userId 发帖用户ID
     * @return 用户发帖总数
     */
    Integer selectPublishPostNumByUserId(Long userId);

    /**
     * 查找所有用户真实看到的阅读量 < 应该达到的阅读量的帖子
     *
     * @return 帖子信息
     */
    List<PostClickCountVo> getUnFullClickPosts();
}
