package com.bxm.localnews.news.domain.activity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.localnews.news.model.dto.GrainPostListItemDTO;
import com.bxm.localnews.news.model.entity.activity.ActivityGrainEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 开仓放粮活动记录 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Mapper
public interface ActivityGrainMapper extends BaseMapper<ActivityGrainEntity> {

    /**
     * 推荐本地的开仓放粮信息
     *
     * @param param 地区查询参数
     * @return 前N条列表
     */
    List<GrainPostListItemDTO> recommend(@Param("param") BaseAreaCodeParam param, @Param("size") Integer size);

    /**
     * 根据帖子查询推广信息
     *
     * @param postId 帖子ID
     * @return 推广记录
     */
    ActivityGrainEntity selectByPostId(Long postId);
}
