package com.bxm.localnews.news.domain.activity;

import com.bxm.localnews.news.model.dto.activity.ActivityPostItemDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.param.activity.ActivityPostPageParam;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface ForumPostActivityMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ForumPostActivityEntity record);

    ForumPostActivityEntity selectByPrimaryKey(Long id);

    /**
     * 根据帖子ID获取活动帖子的额外信息
     *
     * @param postId 帖子ID
     * @return 帖子活动信息
     */
    ForumPostActivityEntity selectByPostId(Long postId);

    int updateByPrimaryKeySelective(ForumPostActivityEntity record);

    /**
     * 分页查询活动帖子信息
     *
     * @param param 分页查询参数
     * @return 分页结果
     */
    List<ActivityPostItemDTO> queryByPage(ActivityPostPageParam param);
}