package com.bxm.localnews.news.domain.activity;

import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashSingleCountEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;

@Mapper
public interface ForumPostShareCashSingleCountMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ForumPostShareCashSingleCountEntity record);

    int insertSelective(ForumPostShareCashSingleCountEntity record);

    ForumPostShareCashSingleCountEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(ForumPostShareCashSingleCountEntity record);

    int updateByPrimaryKey(ForumPostShareCashSingleCountEntity record);

    /**
     * 增加用户的分享帖子收入金额
     *
     * @param userId 用户id
     * @param postId 帖子id
     * @return 影响记录行数
     */
    int increaseAmount(@Param("userId") Long userId,
                       @Param("postId") Long postId,
                       @Param("amount") BigDecimal amount);

    /**
     * 增加用户分享帖子的有效阅读数
     *
     * @param userId 用户id
     * @param postId 帖子id
     * @return 影响记录行数
     */
    int increaseReadCount(@Param("userId") Long userId,
                          @Param("postId") Long postId);

    /**
     * 查询单用户统计信息通过用户id和帖子id
     *
     * @param userId 用户id
     * @param postId 帖子id
     * @return 单用户统计信息
     */
    ForumPostShareCashSingleCountEntity selectByUserIdAndPostId(@Param("userId") Long userId,
                                                                @Param("postId") Long postId);
}