package com.bxm.localnews.news.domain.recommend;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.localnews.news.model.bo.RecommendBO;
import com.bxm.localnews.news.model.param.ForumPostListQueryParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface RecommendMapper {

    /**
     * 我的收藏列表，不包含已经删除的帖子
     */
    IPage<RecommendBO> queryMyCollect(@Param("page") Page<RecommendBO> page, @Param("param") ForumPostListQueryParam param);

    /**
     * 我发布的帖子，分享给其他用户
     */
    IPage<RecommendBO> queryShareRelease(@Param("page") Page<RecommendBO> page, @Param("param") ForumPostListQueryParam param);

    /**
     * 查询用户发布的帖子，如果是用户自己，则可以查看所有的帖子，除了删除的
     * 如果是其他人，则只能查询公开的部分
     */
    IPage<RecommendBO> queryUserRelease(@Param("page") Page<RecommendBO> page, @Param("param") ForumPostListQueryParam param);

    /**
     * 查询当前用户关注的用户发布的内容
     */
    IPage<RecommendBO> queryFollowList(@Param("page") Page<RecommendBO> page, @Param("param") ForumPostListQueryParam param);

    /**
     * 查询本地圈首页推荐信息
     */
    IPage<RecommendBO> queryLocalIndexList(@Param("page") Page<RecommendBO> page, @Param("param") ForumPostListQueryParam param);

    /**
     * 查询话题下的热门内容
     */
    IPage<RecommendBO> queryTopicHotIndexList(@Param("page") Page<RecommendBO> page, @Param("param") ForumPostListQueryParam param);

    /**
     * 查询话题下的新内容
     */
    IPage<RecommendBO> queryTopicNewIndexList(@Param("page") Page<RecommendBO> page, @Param("param") ForumPostListQueryParam param);

}