package com.bxm.localnews.news.domain.recommend;

import com.bxm.localnews.news.facade.dto.RecommendUserDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author liujia
 * @date 9/29/21 5:49 PM
 **/
@Mapper
public interface RecommendUserMapper {

    /**
     * 推荐用户信息
     *
     * @param areaCode
     * @param userId
     * @return
     */
    List<RecommendUserDTO> recommendUser(@Param("areaCode") String areaCode, @Param("userId") Long userId);

    List<ForumPostVo> batchGetUserPosts(@Param("userIdList") List<Long> userIdList,
                                        @Param("advertTopicId") Long advertTopicId,
                                        @Param("isCurrent") Integer isCurrent);
}
