package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.model.vo.action.ForumPostLike;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface ForumPostLikeMapper {

    int insertSelective(ForumPostLike record);

    int updateByPrimaryKeySelective(ForumPostLike record);

    int deleteById(Long id);

    ForumPostLike selectByUserIdAndPostId(@Param("userId") Long userId, @Param("postId") Long postId);

    List<ForumPostLike> selectByPostIdAndOrderByAddtime(Long postId);

    List<ForumPostLike> selectPostById(Long postId);

    int updateNotShowPostLike(Date currentTime);

    List<Long> selectNotExitsUserInfo();

    int updateUserInfoByUserId(ForumPostLike record);

    /**
     * 查询未被展示的点赞记录(半个小时内)
     *
     * @return 未展示的帖子点赞列表
     */
    List<Long> selectNotShowPostLike(Long postId);

    /**
     * 设置帖子的点赞信息为显示状态
     * 未被展示的点赞记录(半个小时内)
     *
     * @param postId 帖子ID
     * @return 处理结果
     */
    int setPostLikeShow(@Param("postId") Long postId);

    /**
     * 根据用户id更新帖子点赞表的用户信息
     */
    int updateNickNameAndHeadImgByUserId(@Param("userId") Long userId,
                                         @Param("nickName") String nickName,
                                         @Param("headImg") String headImg);

    Integer getUserPostLike(@Param("postId") Long postId, @Param("userId") Long userId);

    List<Long> listUserPostLike(@Param("userId") Long userId);
}