package com.bxm.localnews.news.domain;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;

/**
 * @author liujia
 * @date 2/1/21 4:38 PM
 **/
@Mapper
public interface PostHotScoreMapper {

    /**
     * 更新近期的帖子的热度值
     *
     * @param startTime 采用实时热度的帖子的起始时间
     * @return 更新条数
     */
    int updateRuntimeScore(@Param("startTime") Date startTime, @Param("startModifyTime") Date startModifyTime);

    /**
     * 将定时任务执行日期的周期内的过期帖子设置为时间衰减
     * 防止进行全量更新，这里只处理30天之前和包括30天的数据
     *
     * @param startTime 开始时间点
     * @param lastTime  截止时间点
     * @return 更新条数
     */
    int updateHistoryScoreInterval(@Param("startTime") Date startTime, @Param("lastTime") Date lastTime);

    /**
     * 更新帖子的热度值，根据时间衰减
     * 仅处理2日有数据变更（modify_time）的帖子
     *
     * @param lastPublishTime 帖子的发布时间，小于发布时间的会被更新
     * @param startModifyTime 变更时间范围
     * @return 更新行数
     */
    int updateHistoryByModifyTime(@Param("lastPublishTime") Date lastPublishTime, @Param("startModifyTime") Date startModifyTime);
}
