package com.bxm.localnews.news.domain.activity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.localnews.news.model.bo.GrainInfoBO;
import com.bxm.localnews.news.model.dto.grain.GrainPostListItemDTO;
import com.bxm.localnews.news.model.dto.grain.GrainTotalListDTO;
import com.bxm.localnews.news.model.entity.activity.ActivityGrainEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 开仓放粮活动记录 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Mapper
public interface ActivityGrainMapper extends BaseMapper<ActivityGrainEntity> {

    /**
     * 推荐本地的开仓放粮信息
     *
     * @param param 地区查询参数
     * @return 前N条列表
     */
    List<GrainPostListItemDTO> recommend(@Param("param") BaseAreaCodeParam param, @Param("size") Integer size);

    /**
     * 根据帖子查询推广信息
     *
     * @param postId 帖子ID
     * @return 推广记录
     */
    @Deprecated
    ActivityGrainEntity selectByPostId(Long postId);


    /**
     * 根据帖子查询最新推广信息
     *  每次推广的活动只有一个，所以排除所有完成的推广活动，剩下的属于当前的推广活动
     * @param postId 帖子ID
     * @return 推广记录
     */
    ActivityGrainEntity selectLastByPostId(Long postId);


    /**
     * 根据帖子列表查询开仓放粮信息
     * @param postIdList 帖子ID列表
     * @return
     */
    List<GrainInfoBO> selectByPostIdList(@Param("postIdList") List<Long> postIdList);


}
