package com.bxm.localnews.news.domain;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.localnews.news.model.bo.ForumPostDetailBO;
import com.bxm.localnews.news.model.param.AdminForumPostParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 帖子详情获取接口
 * 主要给运营后台使用
 *
 * @author liujia
 * @date 9/12/21 10:44 PM
 **/
@Mapper
public interface ForumPostDetailMapper {

    /**
     * 获取帖子的完整详情，不包括所属区域信息和用户基础信息
     *
     * @param postId 帖子ID
     * @return 帖子详细信息
     */
    ForumPostDetailBO get(Long postId);

    /**
     * 分页查询帖子信息，用于在运营管理后台
     *
     * @param page  分页参数
     * @param param 查询参数
     * @return 分页结果
     */
    IPage<ForumPostDetailBO> getManageListByPage(@Param("page") Page<ForumPostDetailBO> page,
                                                 @Param("param") AdminForumPostParam param);


    /**
     * 根据帖子ID查询帖子详情，用于列表线索
     *
     * @param postIdList 帖子ID列表
     * @return 帖子详情
     */
    List<ForumPostDetailBO> queryDetailList(@Param("postIdList") List<Long> postIdList);
}
