package com.bxm.localnews.news.domain;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.news.model.entity.ForumPostEntity;
import com.bxm.localnews.news.model.vo.PostCount;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 帖子信息表 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Mapper
public interface ForumPostMapper extends BaseMapper<ForumPostEntity> {

    /**
     * 查询最近五分钟的用户新发帖信息，用于通知运营
     *
     * @return 各个地区的发帖数据
     */
    List<PostCount> selectNewPostCount();

    /**
     * 查询某个地区最后发布的内容的时间
     *
     * @param areaCode 发帖区域
     * @return 最后发布时间
     */
    Date selectMaxPublishTime(@Param("areaCode") String areaCode);

    /**
     * 获取帖子的发帖用户ID
     *
     * @param postId 帖子ID
     * @return 用户ID
     */
    Long getUserIdByPostId(Long postId);

    /**
     * 查询在指定区域的话题下的帖子信息
     *
     * @param topicId  话题ID
     * @param limitNum 获取数量
     * @param areaCode 指定区域
     * @return 帖子信息列表
     */
    List<ForumPostEntity> getForumListByTopicId(@Param("topicId") Long topicId,
                                                @Param("limitNum") int limitNum,
                                                @Param("areaCode") String areaCode);
}
