package com.bxm.localnews.news.domain;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.news.model.entity.ForumPostToppingEntity;
import com.bxm.localnews.news.model.vo.ForumToppingPostDTO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 帖子置顶信息表 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Mapper
public interface ForumPostToppingMapper extends BaseMapper<ForumPostToppingEntity> {
    /**
     * 根据帖子id查询置顶信息
     * @param postId 帖子Id
     * @return
     */
    ForumPostToppingEntity getForumPostToppingByPostId(@Param("postId") Long postId);

    /**
     * 删除帖子置顶信息
     * @param postId 帖子id
     * @return
     */
    int deleteForumPostToppingByPostId(@Param("postId") Long postId);

    /**
     * 保存帖子置顶信息
     * @param entity
     * @return
     */
    int saveForumPostTopping(ForumPostToppingEntity entity);

    /**
     * 根据地区获取帖子置顶信息
     * @param areaCode 地区code
     * @return
     */
    List<ForumToppingPostDTO> getForumPostToppingByAreaCode(@Param("areaCode") String areaCode);

    /**
     * 修改帖子置顶状态
     * @param id
     * @param isTopping
     * @return
     */
    int updatePostToppingStatus(@Param("id") Long id, @Param("isTopping") Integer isTopping);

    /**
     * 修改帖子置顶状态 通过postId
     * @param postId
     * @param isTopping
     * @return
     */
    int updateToppingStatusByPostId(@Param("postId") Long postId, @Param("isTopping") Integer isTopping);

    /**
     * 根据帖子id列表查询帖子置顶信息
     * @param postIdList
     * @return
     */
    List<ForumPostToppingEntity> getForumPostToppingByPostList(@Param("postIdList") List<Long> postIdList);
}
