package com.bxm.localnews.news.domain.activity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.news.model.entity.activity.ActivityGrainRecordEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 粮食领取记录 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Mapper
public interface ActivityGrainRecordMapper extends BaseMapper<ActivityGrainRecordEntity> {

    /**
     * 用户是否领取过该帖子对应的奖励
     *
     * @param postId 帖子ID
     * @param userId 用户ID
     * @return 大于0表示领取过
     */
    int hasReceiveRecord(@Param("postId") Long postId, @Param("userId") Long userId);
}
