package com.bxm.localnews.news.domain.activity;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.news.model.dto.grain.GrainTotalListDTO;
import com.bxm.localnews.news.model.entity.activity.ActivityGrainTotalEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 开仓放粮统计数据 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Mapper
public interface ActivityGrainTotalMapper extends BaseMapper<ActivityGrainTotalEntity> {


    int addCount(ActivityGrainTotalEntity entity);

    /**
     * 根据活动推广id查询统计数据
     *
     * @param postId 帖子id
     * @return 开仓放粮统计数据
     */
    List<GrainTotalListDTO> queryActivityGrainTotal(@Param("postId") Long postId);

    /**
     * 保存推广活动激活时间
     *
     * @param grainId    开仓放粮记录ID
     * @param activeTime 激活时间
     * @return 影响行数
     */
    int saveActiveTime(@Param("grainId") Long grainId, @Param("activeTime") Date activeTime);
}
