package com.bxm.localnews.news.domain.activity;


import com.bxm.localnews.news.model.dto.hotpost.HotPostShareCashDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashCounterEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

@Mapper
public interface ForumPostShareCashCounterMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ForumPostShareCashCounterEntity record);

    int insertSelective(ForumPostShareCashCounterEntity record);

    ForumPostShareCashCounterEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(ForumPostShareCashCounterEntity record);

    int updateByPrimaryKey(ForumPostShareCashCounterEntity record);

    /**
     * 获取统计信息通过日期和用户id
     *
     * @param userId     用户id
     * @param currentDay 当前日期
     * @return 账户统计信息
     */
    ForumPostShareCashCounterEntity selectByDateAndUserId(@Param("userId") Long userId,
                                                          @Param("currentDay") String currentDay);

    /**
     * 统计用户奖金总额
     *
     * @param userId     用户id
     * @param currentDay 当前日期
     * @return 用户奖励金额
     */
    BigDecimal countAwardAmount(@Param("userId") Long userId,
                                @Param("currentDay") String currentDay);

    /**
     * 增加当前日期奖励金额
     *
     * @param userId     用户id
     * @param currentDay 当前日期
     * @param amount     增加奖励金额
     * @return 影响记录行数
     */
    int increaseTodayAwardAmount(@Param("userId") Long userId,
                                 @Param("currentDay") String currentDay,
                                 @Param("amount") BigDecimal amount);

    /**
     * 增加今日阅读数
     *
     * @param userId     用户id
     * @param currentDay 当前日期
     * @return 影响记录行数
     */
    int increaseTodayReadCount(@Param("userId") Long userId,
                               @Param("currentDay") String currentDay);

    /**
     * 获取统计信息通过日期
     *
     * @param currentDay 当前日期
     * @return 账户统计信息
     */
    List<ForumPostShareCashCounterEntity> selectByAwardDate(@Param("currentDay") String currentDay);

    /**
     * 获取所有已结算的数据，通过日期
     *
     * @param currentDay 当前日期
     * @return 账户统计信息
     */
    List<ForumPostShareCashCounterEntity> selectByAwardDateAndSettlement(@Param("currentDay") String currentDay);

    /**
     * 获取所有用户的收益信息
     *
     * @return 所有收益信息
     */
    List<HotPostShareCashDTO> getCashInfo();

    /**
     * 获取所有用户的收益信息
     *
     * @param userId 用户id
     * @return 所有收益信息
     */
    HotPostShareCashDTO getUserCashInfo(@Param("userId") Long userId);
}