package com.bxm.localnews.news.domain.activity;


import com.bxm.localnews.news.model.dto.hotpost.ShareCashPostItemDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.param.hotpost.HotPostListPageParam;
import com.bxm.localnews.news.model.param.hotpost.ShareCashPostPageParam;
import com.bxm.localnews.news.model.vo.hotpost.HotPostItemVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Mapper
public interface ForumPostShareCashInfoMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ForumPostShareCashInfoEntity record);

    ForumPostShareCashInfoEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(ForumPostShareCashInfoEntity record);

    int updateAwardTime(ForumPostShareCashInfoEntity record);

    /**
     * 获取热文信息通过帖子id
     *
     * @param postId 帖子id
     * @return 热文信息
     */
    ForumPostShareCashInfoEntity getByPostId(@Param("postId") Long postId);

    /**
     * 分页查询热门帖子信息
     *
     * @param param 分页查询条件
     * @return 热门帖子信息
     */
    List<ShareCashPostItemDTO> queryByPage(ShareCashPostPageParam param);

    /**
     * 增加已发金额
     *
     * @param postId 帖子id
     * @param amount 奖励金额
     * @return 影响行数
     */
    int increaseSendAward(@Param("postId") Long postId,
                          @Param("amount") BigDecimal amount);

    /**
     * 获取热帖列表
     *
     * @param param 查询入参
     * @return 热帖列表
     */
    List<HotPostItemVO> getHotPostList(HotPostListPageParam param);

    /**
     * 获取已经过期的热文
     *
     * @return 热文信息
     */
    List<ForumPostShareCashInfoEntity> getActiveAndExpiredPost(@Param("phaseTime") Date phaseTime);

    /**
     * 下线热文帖子
     *
     * @param postId 热文帖子
     * @return 影响记录行数
     */
    int offlineHotPost(Long postId);

    /**
     * 获取已经到达开始时间的热文
     *
     * @return 热文信息
     */
    List<ForumPostShareCashInfoEntity> getOfflineAndExpiredPost();
}