package com.bxm.localnews.news.facade.service;

import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.ForumPostVo;

import java.util.List;
import java.util.Map;

/**
 * @author liujia
 * @date 9/13/21 8:10 PM
 **/
public interface ForumPostInnerService {

    /**
     * 获取帖子的简略信息
     *
     * @param postId 帖子ID
     * @return 帖子的简略信息
     */
    ForumPostVo getBriefInfo(Long postId);

    /**
     * 获取原本的运营后台帖子详情
     *
     * @param postId 帖子ID
     * @return 运营后台帖子详情
     */
    AdminForumPost getAdminForumPost(Long postId);

    /**
     * 获取帖子的发帖人ID
     *
     * @param postId 帖子ID
     * @return 发帖人ID
     */
    Long getPostUserId(Long postId);

    /**
     * 查询帖子对应的投放区域
     *
     * @param postIdList 帖子ID列表
     * @return 投放信息，key为帖子ID，value为投放区域编码
     */
    Map<Long, List<String>> queryPostRelation(List<Long> postIdList);
}
